package com.topsunit.scanservice.ximai.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 库存调拨参数
 */
@Data
public class StockAllocateParams {

    @ApiModelProperty("调拨明细")
    List<StockAllocateDetail> data;

    @Data
    public static class StockAllocateDetail{
        @ApiModelProperty("物料号")
        String materialNo;
        @ApiModelProperty("物料名称")
        String materialName;
        @ApiModelProperty("仓库")
        String warehouse;
        @ApiModelProperty("储位")
        String location;
        @ApiModelProperty("批号")
        String batchNo;
        @ApiModelProperty("调拨数量")
        BigDecimal allocateQuantity;
        @ApiModelProperty("调入仓库")
        String allocateWarehouse;
        @ApiModelProperty("调出储位")
        String allocateLocation;
    }
}
