package com.topsunit.scanservice.ximai.service.kanban;

import cn.hutool.core.date.DateUtil;
import com.topsunit.scanservice.ximai.dao.MoctaDao;
import com.topsunit.scanservice.ximai.dto.kanban.*;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
public class MaterialStatService {

    @Autowired
    MoctaDao moctaDao;

    public MaterialStatDataDto allData(){
        LocalDateTime currMonth = LocalDateTime.now().withDayOfMonth(1).with(LocalTime.MIN);
        LocalDateTime nextMonth = currMonth.plusMonths(1);
        String startDate = DateUtil.format(currMonth, "yyyyMMdd");
        String endDate = DateUtil.format(nextMonth, "yyyyMMdd");;
        MaterialStatDataDto rst = new MaterialStatDataDto();
        Optional<MaterialDistRatio> materialDistRatio = moctaDao.statMaterialDistRatio(startDate, endDate);
        materialDistRatio.ifPresent(s->{
            if(s.getDenominator().compareTo(BigDecimal.ZERO)>0) {
                rst.setMaterialDistRatio(s.getNumerator().divide(s.getDenominator(), 3, BigDecimal.ROUND_DOWN).multiply(new BigDecimal("100")));
            }
        });
        List<SalesTimelyDeliveryRatio> tempList = moctaDao.statSalesTimelyDeliveryRatio(startDate, endDate);
        int unTimeCt = tempList.size();//销售发货准时率
        String dateStr = DateUtil.format(LocalDateTime.now(), "yyyyMMdd");
        for(SalesTimelyDeliveryRatio temp : tempList){
            String tempDate = temp.getOutDate();
            if(StringUtils.isBlank(tempDate)){
                tempDate = dateStr;
            }
            Integer date = Integer.valueOf(tempDate);
            Integer currDate = Integer.valueOf(dateStr);
            Integer planDate = Integer.valueOf(temp.getPlanOutDate());
            if(date>planDate){
                unTimeCt--;
            }else if(currDate>planDate && temp.getOutQuantity().compareTo(temp.getPlanOutQuantity())<0){
                unTimeCt--;
            }
        }
        if(tempList.size()!=0){
            rst.setSalesTimelyDeliveryRatio(new BigDecimal(unTimeCt)
                    .divide(new BigDecimal(tempList.size()), 3, BigDecimal.ROUND_DOWN).multiply(new BigDecimal("100")));
        }

        Optional<StockInCompleteRatio> stockInCompleteRatio = moctaDao.statStockInCompleteRatio(startDate, endDate);
        stockInCompleteRatio.ifPresent(s->{
            if(s.getDenominator().compareTo(BigDecimal.ZERO)>0) {
                rst.setStockInCompleteRatio(s.getNumerator().divide(s.getDenominator(), 3, BigDecimal.ROUND_DOWN).multiply(new BigDecimal("100")));
            }
        });
        rst.setSalesOutboundPlanList(this.getSalesOutboundPlan(startDate, endDate));
        rst.setInventoryTrend(this.getInventoryTrend(startDate, endDate));
        return rst;
    }

    private List<MaterialStatDataDto.SalesOutboundPlan> getSalesOutboundPlan(String startDate, String endDate){
        List<MaterialStatDataDto.SalesOutboundPlan> rst = new ArrayList<>();
        List<SalesOutboundPlan> list = moctaDao.salesOutboundPlanList(startDate, endDate);
        for (SalesOutboundPlan salesOutboundPlan : list) {
            MaterialStatDataDto.SalesOutboundPlan temp = new MaterialStatDataDto.SalesOutboundPlan();
            temp.setItemNo(salesOutboundPlan.getItemCode());
            temp.setOutApplyNo(salesOutboundPlan.getApplyNo());
            temp.setPlanQuantity(salesOutboundPlan.getPlanOutNum());
            temp.setOutQuantity(salesOutboundPlan.getOutNum());
            temp.setPlanOutDate(salesOutboundPlan.getPlanOutDate());
            rst.add(temp);
        }
        return rst;
    }

    private MaterialStatDataDto.InventoryTrend getInventoryTrend(String startDate, String endDate){
        MaterialStatDataDto.InventoryTrend rst = new MaterialStatDataDto.InventoryTrend();
        List<StockInTrend> stockInTrends = moctaDao.statStockInTrend(startDate, endDate);
        List<StockOutTrend> stockOutTrends = moctaDao.statStockOutTrend(startDate, endDate);
        List<BasicDailyData> stockInTrendList=new ArrayList<>();
        List<BasicDailyData> stockOutTrendList=new ArrayList<>();
        LocalDateTime start = LocalDateTime.now().withDayOfMonth(1).with(LocalTime.MIN);
        LocalDateTime end = start.plusMonths(1).plusDays(-1).with(LocalTime.MAX);
        int dayOfMonth = end.getDayOfMonth();
        for(int i=1;i<=dayOfMonth;i++){
            int j = i;
            String dateStr = DateUtil.format(start, "yyyyMMdd");
            Optional<StockInTrend> stockInOptional = stockInTrends.stream().filter(s->s.getStartDate().equals(dateStr)).findFirst();
            if(!stockInOptional.isPresent()){
                stockInTrendList.add(new BasicDailyData(j, BigDecimal.ZERO));
            }
            stockInOptional.ifPresent(s2->{
                stockInTrendList.add(new BasicDailyData(j, s2.getQuantity()));
            });
            Optional<StockOutTrend> stockOutOptional = stockOutTrends.stream().filter(s->s.getStartDate().equals(dateStr)).findFirst();
            if(!stockOutOptional.isPresent()){
                stockOutTrendList.add(new BasicDailyData(j, BigDecimal.ZERO));
            }
            stockOutOptional.ifPresent(s2->{
                stockOutTrendList.add(new BasicDailyData(j, s2.getQuantity()));
            });
            start = start.plusDays(1);
        }
        rst.setStockInTrend(stockInTrendList);
        rst.setStockOutTrend(stockOutTrendList);
        return rst;
    }



}
