package com.topsunit.scanservice.ximai.service;

import com.topsunit.scanservice.ximai.common.DateUtil;
import com.topsunit.scanservice.ximai.common.OrdinalHelper;
import com.topsunit.scanservice.ximai.common.StringUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.*;
import com.topsunit.scanservice.ximai.dto.PurtgCreateCriteria;
import com.topsunit.scanservice.ximai.dto.PurtgCreateDto;
import com.topsunit.scanservice.ximai.dto.PurtgCreateParams;
import com.topsunit.scanservice.ximai.dto.PurthCreateParams;
import com.topsunit.scanservice.ximai.dto.mapper.PurtgMapper;
import com.topsunit.scanservice.ximai.entity.*;
import com.topsunit.scanservice.ximai.security.CurrentActor;
import com.topsunit.scanservice.ximai.security.CurrentActorSetter;
import com.topsunit.scanservice.ximai.utils.MessageUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>Title: PurtgService</p>
 * <p>Description: 进货单单头档</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/25
 */
@Service
public class PurtgService {
    private final CurrentActor currentActor;
    private final CmsmgDao cmsmgDao;
    private final InvmbDao invmbDao;
    private final InvmcDao invmcDao;
    private final InvmeDao invmeDao;
    private final PurccDao purccDao;
    private final PurcdDao purcdDao;
    private final PurtcDao purtcDao;
    private final PurtdDao purtdDao;
    private final PurtgDao purtgDao;
    private final PurthDao purthDao;
    private final PurmaDao purmaDao;
    private final CmsniDao cmsniDao;
    private final PurtgMapper purtgMapper;
    @Autowired
    ApplicationContext applicationContext;

    public PurtgService(CurrentActor currentActor, CmsmgDao cmsmgDao, InvmbDao invmbDao, InvmcDao invmcDao, InvmeDao invmeDao, PurccDao purccDao, PurcdDao purcdDao, PurtcDao purtcDao, PurtdDao purtdDao, PurtgDao purtgDao, PurthDao purthDao, PurmaDao purmaDao, CmsniDao cmsniDao, PurtgMapper purtgMapper) {
        this.currentActor = currentActor;
        this.cmsmgDao = cmsmgDao;
        this.invmbDao = invmbDao;
        this.invmcDao = invmcDao;
        this.invmeDao = invmeDao;
        this.purccDao = purccDao;
        this.purcdDao = purcdDao;
        this.purtcDao = purtcDao;
        this.purtdDao = purtdDao;
        this.purtgDao = purtgDao;
        this.purthDao = purthDao;
        this.purmaDao = purmaDao;
        this.cmsniDao = cmsniDao;
        this.purtgMapper = purtgMapper;
    }

    public Optional<PurtgCreateDto> getForCreate(PurtgCreateCriteria criteria) {
        Optional<PurtgCreateDto> purtgCreateDto = purccDao
                .findById(purtgMapper.toPurccID(criteria))
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .filter(i -> i.getCc009().trim().equals("Y"))
                .map(purtgMapper::toPurtgCreateDto);
        purtgCreateDto.ifPresent(i -> {
            i.setPurths(purtgMapper.toPurthCreateDtoList(purcdDao.findByCd001AndCd002(criteria.getCc001(), criteria.getCc002()))
                    .stream()
                    .filter(j -> j.getCd018().compareTo(j.getCd020()) > 0)
                    .collect(Collectors.toList()));
            i.getPurths().forEach(j -> {
                getDefaultInvmc(j.getCd004())
                        .ifPresent(x -> {
                            j.setTh009(x.getMc002()); // 默认仓库
                            j.setTh072(x.getMc015()); // 默认库位
                        });
                invmbDao.findById(j.getCd004())
                        .filter(x -> !x.getMb022().trim().equals("N"))
                        .ifPresent(x -> {
                            j.setIslot(true);
                            invmeDao.findFirstByMe001OrderByMe003Desc(j.getCd004())
                                    .map(Invme::getMe002)
                                    .ifPresent(j::setTh010); // 默认批号
                        });
            });
        });
        return purtgCreateDto;
    }

    @Transactional
    public void create(PurtgCreateParams purtgCreateParams) {
        // 到货单单头
        Purcc purcc = purccDao
                .findById(purtgMapper.toPurccID(purtgCreateParams))
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .filter(i -> i.getCc009().trim().equals("Y"))
                .orElseThrow(() -> new TopsunitException(MessageUtils.getMessage("到货单不存在或未检验")));
        List<Purcd> purcds = purcdDao.findByCd001AndCd002(purtgCreateParams.getCc001(), purtgCreateParams.getCc002()); // 到货单单身
        String currentDate = DateUtil.currentDateString();
        Optional<Purma> purma = purmaDao.findById(purcc.getCc005()); // 供应商
        Optional<Cmsmg> cmsmg = purma.flatMap(i -> cmsmgDao.findFirstByMg001OrderByMg002Desc(i.getMa021())); // 币种汇率档

        purcds.stream().collect(Collectors.groupingBy(i -> new PurtcId(i.getCd010(), i.getCd011()))).forEach((purtcId, localPurcds) -> {
            Optional<Purtc> purtc = purtcDao.findById(purtcId); //采购单单头
            Purtg purtg = initPurtg(purtgCreateParams, currentDate, purcc, purma, cmsmg, purtc);
            List<Purth> purths = new ArrayList<>();
            OrdinalHelper ordinalHelper = new OrdinalHelper();
            for (int index = 0; index < localPurcds.size(); index++) {
                Purcd localPurcd = localPurcds.get(index);  // 进货单身
                purths.addAll(initPurth(purtgCreateParams, purtg, ordinalHelper, localPurcd, purcc));
            }
            countPurthForPurtg(purtg, purths);
            purtgDao.save(purtg);
            purths.forEach(i -> purthDao.save(i));
        });
    }

    private Purtg initPurtg(PurtgCreateParams purtgCreateParams,String currentDate,Purcc purcc,Optional<Purma> purma,Optional<Cmsmg> cmsmg,Optional<Purtc> purtc){
        Purtg purtg = new Purtg();
        purtg.setTg001(purtgCreateParams.getTg001()); // 单别
        purtg.setTg002(getNewTG002()); // 单号
        purtg.setTg003(currentDate); // 进货日期
        purtg.setTg004(purcc.getCc004()); // 工厂
        purtg.setTg005(purcc.getCc005()); // 供应商
        purtg.setTg006(purcc.getCc006()); //供应商单号
        purma.ifPresent(i->purtg.setTg007(i.getMa021())); // 币种
        cmsmg.ifPresent(i->purtg.setTg008((i.getMg003()))); // 汇率
        purma.ifPresent(i->purtg.setTg009(i.getMa030())); // 发票种类
        purtc.ifPresent(i->purtg.setTg010(i.getTc018())); // 税种
        // tg011
        // tg012
        purtg.setTg013("N");
        purtg.setTg014(currentDate);
        purtg.setTg015("N");
        // tg016
        // tg017 汇总单身 th019
        // tg018 汇总单身 th020
        // tg019 汇总单身 th046
        // tg020 汇总单身 th024
        purtg.setTg021(purcc.getCc012()); // 供应商全称
        purma.ifPresent(i->purtg.setTg022(i.getMa005())); // 税号
        // tg023
        // tg024
        // tg025
        // tg026 汇总单身 th015
        // tg027
        // tg028 汇总单身 th045
        // tg029
        purtc.ifPresent(i->purtg.setTg030(i.getTc026())); // 增值税率
        // tg031 汇总单身 th047
        // tg032 汇总单身 th048
        purtc.ifPresent(i->purtg.setTg033(i.getTc027())); // 付款条件编号
        // tg034
        // tg035
        // tg036
        // tg037
        // tg038
        // tg039
        // tg040
        // tg041 汇总单身 th052
        purtg.setTg042("N"); // 签核状态码
        purtg.setTg043("N"); // 预留字段
        // tg044
        // tg045
        // tg046
        // tg047
        // tg048
        CurrentActorSetter currentActorSetter = applicationContext.getBean(CurrentActorSetter.class);
        purtg.setTg050("N");
        // tg051
        // tg052
        // tg053 汇总单身 th007
        // tg054 汇总单身 th049
        // tg055
        // tg056
        // tg057
        // tg058
        purtg.setTg059(purcc.getCc026()); // 项目编号
        return purtg;
    }
    private List<Purth>  initPurth(PurtgCreateParams purtgCreateParams ,Purtg purtg, OrdinalHelper ordinalHelper,  Purcd localPurcd,Purcc purcc) {
        List<Purth> purths = new ArrayList<>();

        // 输入参数
        purtgCreateParams.getPurths().stream()
                .filter(i -> i.getCd001().equals(localPurcd.getCd001()))
                .filter(i -> i.getCd002().equals(localPurcd.getCd002()))
                .filter(i -> i.getCd003().equals(localPurcd.getCd003()))
                .forEach(purthCreateParams -> {
                    cmsniDao.findById(new CmsniId(purthCreateParams.getTh009(), purthCreateParams.getTh072()))
                            //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                            .orElseThrow(() -> new TopsunitException(MessageUtils.getMessage("库位不存在")));

                    // 采购单身
                    Optional<Purtd> purtd = purtdDao.findById(new PurtdId(localPurcd.getCd010(), localPurcd.getCd011(), localPurcd.getCd012()));
                    Optional<Invmb> invmb = invmbDao.findById(localPurcd.getCd004());
                    Purth purth = new Purth();
                    purths.add(purth);
                    purth.setTh001(purtg.getTg001()); // 单别
                    purth.setTh002(purtg.getTg002()); // 单号
                    purth.setTh003(ordinalHelper.getNextOrdinal()); // 序号
                    purth.setTh004(localPurcd.getCd004()); // 品号
                    purth.setTh005(localPurcd.getCd005()); // 品名
                    purth.setTh006(localPurcd.getCd006()); // 规格
                    purth.setTh007(localPurcd.getCd018()); // 进货数量
                    purth.setTh008(localPurcd.getCd007()); // 单位
                    purth.setTh009(purthCreateParams.getTh009()); // 仓库
                    purth.setTh010("********************"); // 批号
                    purth.setTh011(localPurcd.getCd010()); // 采购单别
                    purth.setTh012(localPurcd.getCd011()); // 采购单号
                    purth.setTh013(localPurcd.getCd012()); // 采购序号
                    purth.setTh014(purcc.getCc003()); // 验收日期
                    purth.setTh015(purthCreateParams.getTh015()); // 验收数量
                    purth.setTh016(purthCreateParams.getTh016()); // 计价数量
                    purth.setTh017(purthCreateParams.getTh017()); // 验退数量
                    purtd.ifPresent(i -> purth.setTh018(i.getTd010())); // 原币单位金价
                    purth.setTh019(purth.getTh018().multiply(purth.getTh016())); // 原币进货金额
                    // th020
                    // th021
                    // th022
                    // th023
                    // th024
                    // th025
                    purth.setTh026("N"); // 暂不付款
                    purth.setTh027("N"); // 超期码
                    purth.setTh028("2"); // 检验状态
                    purth.setTh029("N"); // 验退吗
                    purth.setTh030("N"); // 审核码
                    purth.setTh031("N"); // 开票码
                    purth.setTh032("N"); // 更新码
                    // th033
                    purth.setTh034(purthCreateParams.getTh015()); // 验收库存数量
                    // th035
                    // th036
                    // th037
                    // th038
                    // th039
                    // th040
                    // th041
                    purth.setTh042(purtg.getTg059()); // 项目编号
                    purth.setTh043("N"); // 生成分录
                    purth.setTh044("N"); // 冲自筹额码
                    // 原币税前金额 原币税额
                    if (purtg.getTg010().equals("1")) {
                        purth.setTh045(purth.getTh018().multiply(purth.getTh016()).divide(purtg.getTg030().add(BigDecimal.ONE), 2));
                        purth.setTh046(purth.getTh018().multiply(purth.getTh016()).subtract(purth.getTh045()));
                    } else if (purtg.getTg010().equals("2")) {
                        purth.setTh045(purth.getTh018().multiply(purth.getTh016()));
                        purth.setTh046(purth.getTh018().multiply(purth.getTh016()).multiply(purtg.getTg030()));
                    } else {
                        purth.setTh045(purth.getTh018().multiply(purth.getTh016()));
                        purth.setTh046(BigDecimal.ZERO);
                    }
                    purth.setTh047(purth.getTh045().multiply(purtg.getTg008())); // 本币税前金额
                    purth.setTh048(purth.getTh046().multiply(purtg.getTg008())); // 本币税额
                    // th049
                    // th050
                    // th051
                    // th052
                    // th053
                    // th054
                    // th055
                    // th056
                    // th057
                    // th058
                    // th059
                    // th060
                    purth.setTh061(localPurcd.getCd026()); // 报废数量
                    purth.setTh062(localPurcd.getCd027()); // 报废包装数量
                    // th063
                    invmb.ifPresent(i -> purth.setTh064(i.getMb149())); // 计价单位
                    invmb.ifPresent(i -> purth.setTh065(i.getMb004())); // 库存单位
                    // th066
                    // th067
                    purth.setTh068(localPurcd.getCd028()); // 破坏数量
                    purth.setTh069(localPurcd.getCd029()); // 破坏包装数量
                    purth.setTh070("N"); // 报废码
                    // th071
                    purth.setTh072(purthCreateParams.getTh072()); // 库位
                    // th073
                    // th074
                    // th075
                    // th076
                    // th077
                    // th078
                    // th079
                    purth.setTh080("N"); // 暂估码
                    // thc01
                    purth.setThc02("2"); // 类型
                    purth.setThc03(localPurcd.getCd001()); // 到货单别
                    purth.setThc04(localPurcd.getCd002()); // 到货单号
                    purth.setThc05(localPurcd.getCd003()); // 到货序号
                    purth.setThc06("0001"); // 检验批次

                    BigDecimal cd020 = localPurcd.getCd020().add(purth.getTh015());
                    if (cd020.compareTo(localPurcd.getCd018()) > 0) {
                        throw new TopsunitException(MessageUtils.getMessage("超出到货单验收数量"));
                    }
                    localPurcd.setCd020(cd020);
                    //purtd.ifPresent(i -> i.setTd015(i.getTd015().add(purth.getTh015())));
                });
        return purths;
    }

    private void countPurthForPurtg(Purtg purtg, List<Purth> purths) {
        for (Purth purth : purths) {
            purtg.setTg017(purtg.getTg017().add(purth.getTh019()));
            purtg.setTg018(purtg.getTg018().add(purth.getTh020()));
            purtg.setTg019(purtg.getTg019().add(purth.getTh046()));
            purtg.setTg020(purtg.getTg020().add(purth.getTh024()));
            purtg.setTg026(purtg.getTg026().add(purth.getTh015()));
            purtg.setTg028(purtg.getTg028().add(purth.getTh045()));
            purtg.setTg031(purtg.getTg031().add(purth.getTh047()));
            purtg.setTg032(purtg.getTg032().add(purth.getTh048()));
            purtg.setTg041(purtg.getTg041().add(purth.getTh052()));
            purtg.setTg053(purtg.getTg053().add(purth.getTh007()));
            purtg.setTg054(purtg.getTg054().add(purth.getTh049()));
        }
    }

    public String getNewTG002() {
        String prefix = DateUtil.currentDateString();
        return purtgDao.findFirstByTg002StartingWithOrderByTg002Desc(prefix)
                .map(i -> {
                    int currentOrdianl = Integer.parseInt(i.getTg002().replace(prefix, ""));
                    return prefix + String.format("%03d", currentOrdianl + 1);
                })
                .orElse(prefix + "001");
    }

    private Optional<Invmc> getDefaultInvmc(String mc001){
        List<Invmc> byMc001 = invmcDao.findByMc001(mc001)
                .stream()
                .filter(i-> !StringUtil.isNullOrEmpty(i.getMc015()))
                .collect(Collectors.toList());
        if(byMc001.isEmpty()){
            return Optional.empty();
        }
        Optional<Invmc> hasMo013 = byMc001
                .stream()
                .filter(i -> !StringUtil.isNullOrEmpty(i.getMc013()))
                .sorted((x, y) -> y.getMc013().compareTo(x.getMc013()))
                .findFirst();
        if(hasMo013.isPresent()){
            return hasMo013;
        }
        return byMc001.stream().findFirst();
    }
}
