package com.topsunit.scanservice.ximai.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.*;
import com.topsunit.scanservice.ximai.dto.PurtaCreateParams;
import com.topsunit.scanservice.ximai.dto.PurtrCreateParams;
import com.topsunit.scanservice.ximai.entity.*;
import com.topsunit.scanservice.ximai.utils.MessageUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicReference;

/**
 * <p>Title: PurtaService</p>
 * <p>Description: 请购单单身信息档服务</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/22
 */
@Service
public class PurtaService {

    @Autowired
    PurtaDao purtaDao;
    @Autowired
    PurtbDao purtbDao;
    @Autowired
    PurtrDao purtrDao;
    @Autowired
    MoctaDao moctaDao;

    @Transactional
    public void create(PurtaCreateParams create){
        Mocta mocta = moctaDao.findById(new MoctaId(create.getWorkorderType(), create.getWorkorderCode()))
                .orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到工单:{0},{1}", create.getWorkorderType(), create.getWorkorderCode())));
        Calendar curr = Calendar.getInstance();
        String currStr = DateUtil.format(curr.getTime(), "yyyyMMdd");
        Purta purta = BeanUtil.toBeanIgnoreError(create, Purta.class);
        purta.setUdf02(mocta.getUdf03());
        purta.setUdf03(mocta.getTa027());
        purta.setTa003(currStr);
        purta.setTa013(currStr);
        StringBuffer note = new StringBuffer();
        AtomicReference<BigDecimal> sum = new AtomicReference<>(BigDecimal.ZERO);
        create.getDetails().forEach(s->{
            Purtb purtb = BeanUtil.toBeanIgnoreError(s, Purtb.class);
            purtb.setTb001(create.getTa001());
            purtb.setTb002(create.getTa002());
            purtb.setTb032(mocta.getTa044());
            purtb.setUdf01(mocta.getUdf03());
            purtb.setUdf04(mocta.getTa006());
            purtb.setUdf10(mocta.getUdf08());
            purtb.setTb029(mocta.getTa026());
            purtb.setTb030(mocta.getTa027());
            purtb.setTb031(mocta.getTa028());
            purtb.setTb009(new BigDecimal(s.getUdf11()));
            purtbDao.save(purtb);
            Purtr purtr = BeanUtil.toBeanIgnoreError(new PurtrCreateParams(), Purtr.class);
            purtr.setTr002(purtb.getTb002());
            purtr.setTr006(new BigDecimal(purtb.getUdf11()));
            purtr.setTr013(purtb.getTb011());
            purtr.setTr015(mocta.getTa044());
            purtrDao.save(purtr);
            sum.set(sum.get().add(purtb.getTb009()));
            note.append(purtb.getTb004()).append("     ").append(mocta.getUdf08()).append("     ").append(purtb.getTb005());
        });
        purta.setTa011(sum.get());
        purta.setTa006(note.toString());
        purtaDao.save(purta);
    }

}
