package com.topsunit.scanservice.ximai.service;

import com.topsunit.scanservice.ximai.dao.*;
import com.topsunit.scanservice.ximai.dto.CopmaCriteria;
import com.topsunit.scanservice.ximai.dto.CopmaDto;
import com.topsunit.scanservice.ximai.dto.PurmaCriteria;
import com.topsunit.scanservice.ximai.dto.PurmaDto;
import com.topsunit.scanservice.ximai.dto.mapper.CopmaMapper;
import com.topsunit.scanservice.ximai.dto.mapper.PurmaMapper;
import com.topsunit.scanservice.ximai.dto.mapper.PurtgMapper;
import com.topsunit.scanservice.ximai.entity.Copma;
import com.topsunit.scanservice.ximai.entity.Purma;
import com.topsunit.scanservice.ximai.security.CurrentActor;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>Title: CopmaService</p>
 * <p>Description: 客户服务</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/16
 */
@Service
public class CopmaService {

    @Autowired
    private CopmaMapper copmaMapper;
    @Autowired
    private CopmaDao copmaDao;

    public List<CopmaDto> getCopmaDtoList(CopmaCriteria criteria) {
        Specification<Copma> query = new Specification<Copma>() {
            @Override
            public Predicate toPredicate(Root<Copma> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                List<Predicate> predicates = new ArrayList<Predicate>();
                if (StringUtils.isNotBlank(criteria.getMa001())) {
                    Predicate predicate = criteriaBuilder.like(root.get("ma001"), criteria.getMa001() + "%");
                    predicates.add(predicate);
                }
                if (StringUtils.isNotBlank(criteria.getMa002())) {
                    Predicate predicate = criteriaBuilder.like(root.get("ma002"), criteria.getMa002() + "%");
                    predicates.add(predicate);
                }
                if (StringUtils.isNotBlank(criteria.getMa003())) {
                    Predicate predicate = criteriaBuilder.like(root.get("ma003"), criteria.getMa003() + "%");
                    predicates.add(predicate);
                }
                return criteriaQuery.where(predicates.toArray(new Predicate[0])).getRestriction();
            }
        };
        List<Copma> list = copmaDao.findAll(query);
        return copmaMapper.toCopmaDtoList(list);
    }

}
