package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.math.BigDecimal;

/**
 * <p>Title: Purtr</p>
 * <p>Description: 请购单单子身信息档</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/22
 */
@Data
@Entity
@IdClass(PurtrId.class)
public class Purtr extends EntityBase {
    @Id
    @ApiModelProperty("单别")
    private String tr001;
    @Id
    @ApiModelProperty("单号")
    private String tr002;
    @Id
    @ApiModelProperty("序号")
    private String tr003;
    @Id
    @ApiModelProperty("序号")
    private String tr004;

    @ApiModelProperty("采购数量")
    private BigDecimal tr006;
    @ApiModelProperty("采购比率")
    private BigDecimal tr007;
    @ApiModelProperty("采购单位")
    private String tr008;
    @ApiModelProperty("采购币种")
    private String tr009;
    @ApiModelProperty("采购单价")
    private BigDecimal tr010;
    @ApiModelProperty("采购金额")
    private BigDecimal tr011;
    @ApiModelProperty("税种")
    private String tr012;
    @ApiModelProperty("交货日")
    private String tr013;
    @ApiModelProperty("交货仓库")
    private String tr014;
    @ApiModelProperty("采购码")
    private String tr017;
    @ApiModelProperty("锁定码")
    private String tr018;
    @ApiModelProperty("采购小单位")
    private String tr024;
    @ApiModelProperty("计价单位")
    private String tr026;
    @ApiModelProperty("急料")
    private String tr015;

}
