package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: PurtdId</p>
 * <p>Description: 采购单单身信息档主键</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/22
 */
public class PurtdId implements Serializable {
    public PurtdId() {
    }

    public PurtdId(String td001, String td002, String td003) {
        this.td001 = String.format("%1$-4s", td001);
        this.td002 = String.format("%1$-11s", td002);
        this.td003 = String.format("%1$-4s", td003);
    }

    private String td001;
    private String td002;
    private String td003;

    public String getTd001() {
        return td001;
    }

    public void setTd001(String td001) {
        this.td001 = td001;
    }

    public String getTd002() {
        return td002;
    }

    public void setTd002(String td002) {
        this.td002 = td002;
    }

    public String getTd003() {
        return td003;
    }

    public void setTd003(String td003) {
        this.td003 = td003;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PurtdId purtdId = (PurtdId) o;
        return td001.equals(purtdId.td001) && td002.equals(purtdId.td002) && td003.equals(purtdId.td003);
    }

    @Override
    public int hashCode() {
        return Objects.hash(td001, td002, td003);
    }
}
