package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.math.BigDecimal;

/**
 * <p>Title: Purtc</p>
 * <p>Description: 采购单单头信息档</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/22
 */
@Data
@Entity
@IdClass(PurtcId.class)
public class Purtc extends EntityBase {
    @Id
    @ApiModelProperty("采购单别")
    private String tc001;
    @Id
    @ApiModelProperty("采购单号")
    private String tc002;
    @ApiModelProperty("供应商")
    private String tc004;
    @ApiModelProperty("工厂")
    private String tc010;
    @Column
    @ApiModelProperty("税种")
    private String tc018;
    @Column
    @ApiModelProperty("增值税率")
    private BigDecimal tc026;
    @Column
    @ApiModelProperty("付款条件编号")
    private String tc027;

}
