package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: PurcdId</p>
 * <p>Description: 到货单单身档主键</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/19
 */
public class PurcdId implements Serializable {
    public PurcdId() {
    }

    public PurcdId(String cd001, String cd002, String cd003) {
        this.cd001 = String.format("%1$-4s", cd001);
        this.cd002 = String.format("%1$-11s", cd002);
        this.cd003 = String.format("%1$-4s", cd003);
    }

    private String cd001;
    private String cd002;
    private String cd003;

    public String getCd001() {
        return cd001;
    }

    public void setCd001(String cd001) {
        this.cd001 = cd001;
    }

    public String getCd002() {
        return cd002;
    }

    public void setCd002(String cd002) {
        this.cd002 = cd002;
    }

    public String getCd003() {
        return cd003;
    }

    public void setCd003(String cd003) {
        this.cd003 = cd003;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PurcdId purcdId = (PurcdId) o;
        return cd001.equals(purcdId.cd001) && cd002.equals(purcdId.cd002) && cd003.equals(purcdId.cd003);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cd001, cd002, cd003);
    }
}
