package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: MocthId</p>
 * <p>Description: 委外进货单头档Id</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/27
 */
public class MocthId implements Serializable {
    public MocthId() {
    }

    public MocthId(String th001, String th002) {
        this.th001 = String.format("%1$-4s", th001);
        this.th002 = String.format("%1$-11s", th002);
    }

    private String th001;
    private String th002;

    public String getTh001() {
        return th001;
    }

    public void setTh001(String th001) {
        this.th001 = th001;
    }

    public String getTh002() {
        return th002;
    }

    public void setTh002(String th002) {
        this.th002 = th002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MocthId mocthId = (MocthId) o;
        return th001.equals(mocthId.th001) && th002.equals(mocthId.th002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(th001, th002);
    }
}
