package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * Author:   Jack
 * Date:     2021/10/28 20:10
 * Description: 工单单身Id
 */
public class MoctbId implements Serializable {

    public MoctbId() {
    }

    public MoctbId(String tb001, String tb002, String tb003, String tb006) {
        this.tb001 = String.format("%1$-4s", tb001);
        this.tb002 = String.format("%1$-11s", tb002);
        this.tb003 = String.format("%1$-20s", tb003);
        this.tb006 = String.format("%1$-4s", tb006);
    }

    private String tb001;
    private String tb002;
    private String tb003;
    private String tb006;

    public String getTb001() {
        return tb001;
    }

    public void setTb001(String tb001) {
        this.tb001 = tb001;
    }

    public String getTb002() {
        return tb002;
    }

    public void setTb002(String tb002) {
        this.tb002 = tb002;
    }

    public String getTb003() {
        return tb003;
    }

    public void setTb003(String tb003) {
        this.tb003 = tb003;
    }

    public String getTb006() {
        return tb006;
    }

    public void setTb006(String tb006) {
        this.tb006 = tb006;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MoctbId moctbId = (MoctbId) o;
        return tb001.equals(moctbId.tb001) && tb002.equals(moctbId.tb002) && tb003.equals(moctbId.tb003) && tb006.equals(moctbId.tb006);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tb001, tb002, tb003, tb006);
    }
}
