package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.math.BigDecimal;

/**
 * Author:   Jack
 * Date:     2021/10/29 21:42
 * Description: 品号仓库库位档
 */
@Data
@Entity
@IdClass(InvmlId.class)
public class Invml extends EntityBase {
    /**
     * 品号
     */
    @Id
    @ApiModelProperty("品号")
    private String ml001;

    /**
     * 仓库
     */
    @Id
    @ApiModelProperty("仓库")
    private String ml002;

    /**
     * 库位
     */
    @Id
    @ApiModelProperty("库位")
    private String ml003;

    /**
     * 批号
     */
    @Id
    @ApiModelProperty("批号")
    private String ml004;

    /**
     * 库存数量
     */
    @ApiModelProperty("库存数量")
    private BigDecimal ml005;

    /**
     * 库存包装数量
     */
    @ApiModelProperty("库存包装数量")
    private BigDecimal ml006;

    /**
     * 预留字段 库存金额
     */
    @ApiModelProperty("库存金额")
    private BigDecimal ml007;

    /**
     * 上次盘点日
     */
    @ApiModelProperty("上次盘点日")
    private String ml008;

    /**
     * 最近入库日
     */
    @ApiModelProperty("最近入库日")
    private String ml009;

    /**
     * 最近出库日
     */
    @ApiModelProperty("最近出库日")
    private String ml010;

}
