package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: InvmeId</p>
 * <p>Description: 品号批号信息单头Id</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/26
 */
public class InvmeId implements Serializable {
    private String me001;
    private String me002;

    public InvmeId() {
    }

    public InvmeId(String me001, String me002) {
        this.me001 = String.format("%1$-20s", me001);
        this.me002 = String.format("%1$-20s", me002);
    }

    public String getMe001() {
        return me001;
    }

    public void setMe001(String me001) {
        this.me001 = me001;
    }

    public String getMe002() {
        return me002;
    }

    public void setMe002(String me002) {
        this.me002 = me002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvmeId invmeId = (InvmeId) o;
        return me001.equals(invmeId.me001) && me002.equals(invmeId.me002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(me001, me002);
    }
}
