package com.topsunit.scanservice.ximai.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: InvmdId</p>
 * <p>Description: 品号换算单位档</p>
 *
 * @author xi.feng
 * @version V1.0
 */
@Data
public class InvmaId implements Serializable {

    public InvmaId() {
    }

    public InvmaId(String ma001, String ma002) {
        this.ma001 = String.format("%1$-20s", ma001);;
        this.ma002 = String.format("%1$-4s", ma002);;
    }

    /**
     * 品号
     */
    private String ma001;

    /**
     * 换算单位
     */
    private String ma002;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvmaId invmdId = (InvmaId) o;
        return ma001.equals(invmdId.ma001) && ma002.equals(invmdId.ma002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ma001, ma002);
    }
}
