package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: CmsniId</p>
 * <p>Description: 仓库库位档Id</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/29
 */
public class CmsniId implements Serializable {
    public CmsniId() {
    }

    public CmsniId(String ni001, String ni002) {
        this.ni001 = String.format("%1$-10s",ni001);;
        this.ni002 = String.format("%1$-10s",ni002.trim());
    }

    /**
     * 仓库编号
     */
    private String ni001;
    /**
     * 库位编号
     */
    private String ni002;

    public String getNi001() {
        return ni001;
    }

    public void setNi001(String ni001) {
        this.ni001 = ni001;
    }

    public String getNi002() {
        return ni002;
    }

    public void setNi002(String ni002) {
        this.ni002 = ni002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CmsniId cmsniId = (CmsniId) o;
        return ni001.equals(cmsniId.ni001) && ni002.equals(cmsniId.ni002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ni001, ni002);
    }
}
