package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: AdmmfId</p>
 * <p>Description: 用户信息Id</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/11/8
 */
public class AdmmfId implements Serializable {
    public AdmmfId() {
    }

    public AdmmfId(String mf001, String mf004) {
        this.mf001 = String.format("%1$-10s", mf001);
        this.mf004 = String.format("%1$-10s", mf004);
    }

    /**
     * 用户编号
     */
    private String mf001;
    /**
     * 组编号
     */
    private String mf004;

    public String getMf001() {
        return mf001;
    }

    public void setMf001(String mf001) {
        this.mf001 = mf001;
    }

    public String getMf004() {
        return mf004;
    }

    public void setMf004(String mf004) {
        this.mf004 = mf004;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdmmfId admmfId = (AdmmfId) o;
        return mf001.equals(admmfId.mf001) && mf004.equals(admmfId.mf004);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mf001, mf004);
    }
}
