package com.topsunit.scanservice.ximai.dto.mapper;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.entity.Purcc;
import com.topsunit.scanservice.ximai.entity.PurccId;
import com.topsunit.scanservice.ximai.entity.Purcd;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;

import java.util.List;

/**
 * <p>Title: PurccMapper</p>
 * <p>Description: 到货单映射</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/20
 */
@Mapper(componentModel = "spring")
public interface PurccMapper {
    PurccId toPurccID(PurccIdCriteria criteria);

    PurccId toPurccID(PurccCheckParams purccCheckParams);

    PurccDto toPurccDto(Purcc purcc);

    List<PurccDto> toPurccDtoList(List<Purcc> purccs);

    PurcdDto toPurcdDto(Purcd purcd);

    List<PurcdDto> toPurcdDtoList(List<Purcd> purcds);

    @Mapping(target = "cd001", ignore = true)
    @Mapping(target = "cd002", ignore = true)
    @Mapping(target = "cd003", ignore = true)
    void updatePurcd(PurcdCheckParams purcdCheckParams, @MappingTarget Purcd purcd);
}
