package com.topsunit.scanservice.ximai.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 销售出库参数
 */
@Data
public class StockSaleOutParams {

    @ApiModelProperty("交货单号")
    String applyNo;

    @ApiModelProperty("确认明细")
    List<StockSaleOutParams.StockSaleOutDetail> data;
    @Data
    public static class StockSaleOutDetail{
        @ApiModelProperty("物料号")
        String materialNo;
        @ApiModelProperty("物料名称")
        String materialName;
        @ApiModelProperty("单位")
        String unit;
        @ApiModelProperty("计划出库日期")
        String planOutDate;
        @ApiModelProperty("交货数量")
        BigDecimal deliverQuantity;
        @ApiModelProperty("出库数量")
        BigDecimal outQuantity;
        @ApiModelProperty("仓库")
        String warehouse;
        @ApiModelProperty("储位")
        String location;
    }
}
