package com.topsunit.scanservice.ximai.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Id;
import java.math.BigDecimal;

/**
 * <p>Title: PurmaDto</p>
 * <p>Description: 供应商</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/16
 */
@Data
public class PurmaDto {

    @ApiModelProperty("供应商编号")
    private String ma001;

    @ApiModelProperty("简称")
    private String ma002;

    @ApiModelProperty("公司全称")
    private String ma003;

    @ApiModelProperty("税号")
    private String ma005;

    /**
     * 1:已核准、2:尚待核准、3:不准交易
     */
    @ApiModelProperty("核准状态")
    private String ma016;

    @ApiModelProperty("交易币种")
    private String ma021;

    /**
     * 1.二联式、2.三联式、3.二联式收银机发票、4.三联式收银机发票、5.电子计算机发票、6.免用统一发票、S.可抵扣专用发票、B.普通发票、T.运输发票、N.不可抵扣专用发票 A.农产品收购凭证、G.海关代征完税凭证、W.废旧物资收购凭证、Z.其他 //901025 S06-9009036 MODI A~Z   //8
     */
    @ApiModelProperty("发票种类")
    private String ma030;

    @ApiModelProperty("备注")
    private String ma040;
}
