package com.topsunit.scanservice.ximai.dao;

import com.topsunit.scanservice.ximai.dto.IInvmlDto;
import com.topsunit.scanservice.ximai.dto.InvmlDto;
import com.topsunit.scanservice.ximai.entity.Invml;
import com.topsunit.scanservice.ximai.entity.InvmlId;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Optional;

/**
 * Author:   Jack
 * Date:     2021/10/29 21:56
 * Description: 品号仓库库位档Dao
 */
public interface InvmlDao extends JpaRepository<Invml, InvmlId>, JpaSpecificationExecutor<Invml> {
    List<Invml> findByMl001OrderByMl002AscMl003AscMl004Asc(String ml001);
    List<Invml> findByMl001InOrderByMl002AscMl003AscMl004Asc(List<String> ml001List);


    /**
     * 通过品号仓库、库位查询库存
     * @param ml001 品号
     * @param ml002 仓库
     * @param ml003 库位
     * @return
     */
    Optional<Invml> findFirstByMl001AndMl002AndMl003AndMl004(String ml001, String ml002, String ml003, String ml004);

    @Query(value = "select il.*,ib.MB002 materialName from INVML il left join INVMB ib on il.ML001 = ib.MB001 where il.ML001 = :ml001 and ('' = ISNULL(CONVERT(varchar(200), :ml002),'') or il.ML002 = :ml002)" +
            " and ('' = ISNULL(CONVERT(varchar(200), :gtStock),'') or il.ML005 > :gtStock)", nativeQuery = true)
    List<IInvmlDto> findJoinInvmb(@Param(value = "ml001") String ml001, @Param(value = "ml002") String ml002, @Param(value = "gtStock") Integer gtStock);

    /*
    关联通知单查询库明细
     */
    @Query(value = "select il.*,co.TO008 materialName from COPTO co left join INVML il on il.ML001 = co.TO007 where TO001 = :to001 and TO002 = :to002", nativeQuery = true)
    List<IInvmlDto> findWithCopto(@Param(value = "to001") String to001, @Param(value = "to002") String to002);
}
