package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.SfctaCriteria;
import com.topsunit.scanservice.ximai.dto.SfctaDto;
import com.topsunit.scanservice.ximai.service.SfctaService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;

/**
 * <p>Title: SfctaController</p>
 * <p>Description: 工单工艺信息档 Controller</p>
 *
 * @author xi.feng
 * @version V1.0
 */
@RestController
public class SfctaController {
    private final SfctaService sfctaService;

    public SfctaController(SfctaService sfctaService) {
        this.sfctaService = sfctaService;
    }

    @PostMapping("/sfcta/getforscan")
    public Optional<SfctaDto> getForScan(@RequestBody SfctaCriteria criteria){
        return sfctaService.getForScan(criteria);
    }
}
