package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.service.PurmaService;
import com.topsunit.scanservice.ximai.service.PurtgService;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * <p>Title: PurmaController</p>
 * <p>Description: 供应商</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2024/10/17
 */
@RestController
public class PurmaController {

    @Autowired
    private PurmaService purmaService;

    @ApiOperation("查询供应商列表")
    @PostMapping("/purma/getPurmaList")
    public List<PurmaDto> getForCreate(@RequestBody PurmaCriteria criteria){
        return purmaService.getPurmaDtoList(criteria);
    }

}
