package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.service.MocthService;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;

/**
 * <p>Title: MocthController</p>
 * <p>Description: 委外进货单</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/27
 */
@RestController
public class MocthController {
    private final MocthService mocthService;

    public MocthController(MocthService mocthService) {
        this.mocthService = mocthService;
    }

    @ApiOperation("委外进货打印查询")
    @PostMapping("/mocth/getforprint")
    public Optional<MocthDto> getForPrint(@RequestBody MocthIdCriteria criteria){
        return mocthService.getForPrint(criteria);
    }
    @ApiOperation("委外检验查询")
    @PostMapping("/mocth/getforcheck")
    public Optional<MocthDto> getForCheck(@RequestBody MocthIdCriteria criteria){
        return mocthService.getForCheck(criteria);
    }


    @ApiOperation("委外扫码上架")
    @PostMapping("/mocth/getforputon")
    public Optional<MocthDto> getForPutOn(@RequestBody MocthIdCriteria criteria){
        return mocthService.getForPutOn(criteria);
    }

    @ApiOperation("委外进货打印")
    @PostMapping("/mocth/print")
    public void print(@RequestBody MocthPrintParams printParams){
        mocthService.print(printParams);
    }

    @ApiOperation("委外检验确认")
    @PostMapping("/mocth/check")
    public void check(@RequestBody MocthCheckParams checkParams){
        mocthService.check(checkParams);
    }

    @PostMapping("/mocth/puton")
    public void putOn(@RequestBody MocthPutOnParams putOnParams){
        mocthService.putOn(putOnParams);
    }
}
