package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.service.InvmbService;
import com.topsunit.scanservice.ximai.service.InvmcService;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * <p>Title: InvmcController</p>
 * <p>Description: 品号仓储信息档</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/12/27
 */
@RestController
public class InvmcController {

    @Autowired
    private InvmcService invmcService;

    @ApiModelProperty("品号仓储信息查询")
    @PostMapping("/invml/getforinvmlinfo")
    public List<InvmlDto> getForInvmbInfo(@RequestBody InvmlCriteria criteria) {
        return invmcService.getInvmlList2(criteria);
    }

}
