package com.topsunit.scanservice.ximai.common;

import com.topsunit.scanservice.ximai.dto.LoginResult;
import com.topsunit.scanservice.ximai.security.TokenAudience;
import com.topsunit.scanservice.ximai.security.TokenManger;
import com.topsunit.scanservice.ximai.security.TokenService;
import com.topsunit.scanservice.ximai.security.impl.TokenMangerImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.LocaleResolver;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Locale;

@Component
public class XimaiLocaleResolver implements LocaleResolver {

    @Autowired
    TokenManger tokenManger;
    @Override
    public void setLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
    }

    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if(StringUtils.isNotEmpty(token) && !token.startsWith("Basic")){
            TokenAudience tokenAudience = tokenManger.getTokenAudience(token);
            if(StringUtil.isNullOrEmpty(tokenAudience.getLocal())){
                return Locale.getDefault();
            }else{
                String locale = tokenAudience.getLocal();
                String[] localeArr = locale.split("-");
                if(localeArr.length==1){
                    return new Locale(locale, "");
                }else{
                    return new Locale(localeArr[0], localeArr[1]);
                }
            }
        }
        return Locale.getDefault();
    }
}

