package com.topsunit.scanservice.ximai.common;

/**
 * <p>Title: StringUtil</p>
 * <p>Description: 字符串工具类</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/11/4
 */
public class StringUtil {

    public static boolean isNullOrEmpty(String s){
        if(s==null){
            return true;
        }
        if(s.trim().isEmpty()){
            return true;
        }
        return false;
    }

    private static final String[] strHex={"0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"};
    public static String byteTo16(byte bt){
        int low =(bt & 15);
        int high = bt>>4 & 15;
        return strHex[high]+strHex[low];
    }
    public static String byteArrayTo16(byte[] data){
        if(data == null || data.length == 0){
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(data.length*2+10);
        stringBuilder.append("0x");
        for(byte bt : data){
            stringBuilder.append(byteTo16(bt));
        }
        return stringBuilder.toString();
    }
}
