package com.topsunit.scanservice.ximai.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * <p>Title: GlobalHandlerExceptionResolver</p>
 * <p>Description: 处理异常返回</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/19
 */
@Component
public class GlobalHandlerExceptionResolver implements HandlerExceptionResolver {
    private final JsonView view;

    private static final Logger log = LoggerFactory.getLogger(GlobalHandlerExceptionResolver.class);

    public GlobalHandlerExceptionResolver(JsonView view) {
        this.view = view;
    }

    @Override
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ModelAndView modelAndView = new ModelAndView(getView());
        modelAndView.addObject(ServiceResult.ofException(ex));
        log.error("系统异常", ex);
        return modelAndView;
    }

    private View getView(){
        return view;
    }

    @Component
    public  static class JsonView implements View {

        private final ObjectMapper mapper;

        public JsonView(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public String getContentType() {
            return "application/json;charset=utf-8";
        }

        @Override
        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            response.setContentType("application/json;charset=utf-8");
            response.getOutputStream().write(mapper.writeValueAsBytes(model.values().stream().findFirst()));
        }
    }
}