package com.topsunit.scanservice.ximai.common;

/**
 * 文件系统异常
 *
 * @author vacoor
 */
public class FileSystemException extends RuntimeException {

    public FileSystemException() {
    }

    public FileSystemException(String message) {
        super(message);
    }

    public FileSystemException(String message, Throwable cause) {
        super(message, cause);
    }

    public FileSystemException(Throwable cause) {
        super(cause);
    }

    public static <R> R rethrowFileSystemException(Throwable exception) {
        if (exception instanceof Error) {
            throw (Error) exception;
        }
        exception.printStackTrace();
        if (exception instanceof FileSystemException) {
            throw (FileSystemException) exception;
        }
        throw new FileSystemException(exception);
    }
}
