package com.topsunit.scanservice.ximai.common;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Aspect
@Component
public class ControllerLoggingAspect {
    private static final Logger logger = LoggerFactory.getLogger("com.topsunit.scanservice.ximai.controller");

    // 定义切点，拦截控制器中的所有方法
    @Pointcut("execution(* com.topsunit.scanservice.ximai.controller..*(..))")
    public void controllerPointcut() {
    }

    // 在控制器方法执行前添加日志记录
    @Before("controllerPointcut()")
    public void logBefore(JoinPoint joinPoint) {
        if(logger.isDebugEnabled()) {
            ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = attributes.getRequest();

            StringBuilder logMessage = new StringBuilder();
            logMessage.append("Request to ").append(request.getRequestURI()).append(" | Method: ").append(request.getMethod()).append("\n");
            logMessage.append("Parameters: ");

            MethodSignature signature = (MethodSignature) joinPoint.getSignature();
            Method method = signature.getMethod();
            Parameter[] parameters = method.getParameters();
            Map<String, Object> parameterMap = new HashMap<>();
            for (int i = 0; i < parameters.length; i++) {
                Parameter parameter = parameters[i];
                String parameterName = parameter.getName();
                Object value = joinPoint.getArgs()[i];
                parameterMap.put(parameterName, value);
            }
            logMessage.append(parameterMap);

            logger.debug(logMessage.toString());
        }
    }
}
