package com.topsunit.scanservice.ximai.common;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * <p>Title: AppConfig</p>
 * <p>Description: 配置文件读yml</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/26
 */
@Data
@Configuration
public class AppConfig {
    @Value("${topsunit.token-expires-hour}")
    private Long tokenExpiresHour;
    @Value("${topsunit.token-secret}")
    private String tokenSecret;

    public Long getTokenExpires() {
        if(tokenExpiresHour == null) {
            return (long) (60* 60 * 1000);
        }
        return tokenExpiresHour * 60 * 60 * 1000;
    }

    @Value("${topsunit.authentication-enabled}")
    private Boolean authenticationEnabled;

    @Value("${topsunit.db-name}")
    private String dbName;

    public  boolean getAuthenticationEnabled(){
        if(authenticationEnabled == null){
            return true;
        }
        return authenticationEnabled;
    }

    @Value("${topsunit.print-api-url}")
    private String printApiUrl;

    @Value("${topsunit.default-password}")
    private String defaultPassword;

    /**
     * 共享文件地址
     */
    @Value("${topsunit.share-url}")
    private String shareUrl;

    /**
     * MES接口地址
     */
    @Value("${topsunit.mes-url}")
    private String mesUrl;
}
