package com.topsunit.scanservice.ximai.common;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.springframework.stereotype.Component;

/**
 * <p>Title: PhysicalNamingStrategyUpperCaseImpl</p>
 * <p>Description: PhysicalNamingStrategyUpperCaseImpl</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/19
 */
@Component
public class PhysicalNamingStrategyUpperCaseImpl extends PhysicalNamingStrategyStandardImpl {
    @Override
    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment context) {
        return Identifier.toIdentifier(name.getText().toUpperCase(), name.isQuoted());
    }

    @Override
    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment context) {
        return Identifier.toIdentifier(name.getText().toUpperCase(), name.isQuoted());
    }
}
