package com.topsunit.scanservice.ximai.barcode.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * <p>Title: BoxCodeQueryResultDto</p>
 * <p>Description: 箱码查询小标签条码结果数据传输对象</p>
 *
 * @author system
 * @version V1.0
 * @date 2025/01/23
 */
@Data
public class BoxCodeQueryResultDto {
    
    // ATCstDm 字段
    @ApiModelProperty("主键ID")
    private String id;
    
    @ApiModelProperty("业务员ID")
    private BigDecimal emplID;
    
    @ApiModelProperty("业务员编码")
    private String emplNo;
    
    @ApiModelProperty("业务员")
    private String emplName;
    
    @ApiModelProperty("部门ID")
    private BigDecimal deptId;
    
    @ApiModelProperty("部门编码")
    private String deptNo;
    
    @ApiModelProperty("部门")
    private String deptName;
    
    @ApiModelProperty("单据号")
    private String mNo;
    
    @ApiModelProperty("日期")
    private String bdt;
    
    @ApiModelProperty("零件ID")
    private String mItemID;
    
    @ApiModelProperty("零件号")
    private String mitemno;
    
    @ApiModelProperty("客户品号")
    private String mitemno_1;
    
    @ApiModelProperty("零件名称")
    private String mItemName;
    
    @ApiModelProperty("计划日期")
    private String ymdt;
    
    @ApiModelProperty("包装数量")
    private String mQty;
    
    @ApiModelProperty("箱码")
    private String pSNNo;
    
    @ApiModelProperty("早晚班")
    private String trick;
    
    @ApiModelProperty("车型")
    private String iType;
    
    @ApiModelProperty("包装方式")
    private String ipackinfo;
    
    @ApiModelProperty("备注")
    private String mNote;
    
    @ApiModelProperty("制单人")
    private String cuser;
    
    @ApiModelProperty("制单人编码")
    private String cuserNo;
    
    @ApiModelProperty("创建时间")
    private String cdt;
    
    @ApiModelProperty("MGPK")
    private String mgpk;
    
    // ATCstDs 字段
    @ApiModelProperty("派工明细ID")
    private String dsId;
    
    @ApiModelProperty("itemmgpk")
    private String itemmgpk;
    
    @ApiModelProperty("零件号")
    private String sItemNo;
    
    @ApiModelProperty("客户品号")
    private String sItemNo_1;
    
    @ApiModelProperty("零件名称")
    private String sItemName;
    
    @ApiModelProperty("规格型号")
    private String spec;
    
    @ApiModelProperty("包装数量")
    private String itemrpack;
    
    @ApiModelProperty("数量")
    private BigDecimal snqty;
    
    @ApiModelProperty("小标签条码")
    private String snNo;
    
    @ApiModelProperty("条码")
    private String snno1;
    
    @ApiModelProperty("备注")
    private String srNote;
    
    @ApiModelProperty("SURID")
    private BigDecimal surid;
    
    @ApiModelProperty("SAUID")
    private String sauid;
    
    @ApiModelProperty("SGPK")
    private String sgpk;
}
