package com.topsunit.scanservice.ximai.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.topsunit.scanservice.ximai.common.DateUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.*;
import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.entity.*;
import com.topsunit.scanservice.ximai.utils.MessageUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.service.spi.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;

@Service
public class CopthService {

    @Autowired
    private CopthDao copthDao;
    @Autowired
    private CoptgDao coptgDao;
    @Autowired
    private CoptnDao coptnDao;
    @Autowired
    private CoptoDao coptoDao;
    @Autowired
    private CoptcDao coptcDao;
    @Autowired
    private CoptdDao coptdDao;
    @Autowired
    private CopmaDao copmaDao;


    @Transactional
    public void create(StockSaleOutParams params){
        Coptn coptn = coptnDao.findFirstByTn001AndTn002("251", params.getApplyNo())
                .orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到出货通知单：")+params.getApplyNo()));
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal total013 = BigDecimal.ZERO;
        BigDecimal total025 = BigDecimal.ZERO;
        BigDecimal total045 = BigDecimal.ZERO;
        BigDecimal total046 = BigDecimal.ZERO;
        Calendar curr = Calendar.getInstance();
        String currStr = cn.hutool.core.date.DateUtil.format(curr.getTime(), "yyyyMMdd");
        Coptg coptg = BeanUtil.copyProperties(new CoptgCreateParams(), Coptg.class);
        Copma copma =  copmaDao.findById(coptn.getTn004())
                .orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到客户：{0}",coptg.getTg004())));
        coptg.setTg002(this.getNewTg002(coptg.getTg001()));
        coptg.setTg003(currStr);
        coptg.setTg042(currStr);
        coptg.setTg004(coptn.getTn004());
        coptg.setTg005(coptn.getTn006());
        coptg.setTg006(coptn.getTn007());
        coptg.setTg008(coptn.getTn009());
        coptg.setTg009(coptn.getTn010());
        coptg.setTg011(coptn.getTn013());
        coptg.setTg012(coptn.getTn014());
        coptg.setTg017(coptn.getTn011());
        coptg.setTg044(coptn.getTn030());
        coptg.setTg008(copma.getMa027());
        coptg.setTg016(copma.getMa037());
        int i = 1;
        for(StockSaleOutParams.StockSaleOutDetail s : params.getData()){
            s.setWarehouse(StrUtil.trim(s.getWarehouse()));
            s.setLocation(StrUtil.trim(s.getLocation()));
            //查询出货通知单明细
            Copto copto = coptoDao.findFirstByTo001AndTo002AndTo007("251", params.getApplyNo(), s.getMaterialNo())
                .orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到出货通知单明细:{0},{1}", params.getApplyNo(), s.getMaterialNo())));
            //查询销售订单明细
            Coptd coptd = coptdDao.findFirstByTd001AndTd002AndTd003(copto.getTo004(), copto.getTo005(), copto.getTo006())
                    .orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到销售订单:{0},{1},{2}", copto.getTo004(), copto.getTo005(), copto.getTo006())));
            CopthCreateParams copthCreateParams = new CopthCreateParams();
            Copth copth = BeanUtil.copyProperties(copthCreateParams, Copth.class);
            copth.setTh001(coptg.getTg001());
            copth.setTh002(coptg.getTg002());
            copth.setTh003(StringUtils.leftPad(i+"",4, "0"));
            copth.setTh004(s.getMaterialNo());
            copth.setTh005(s.getMaterialName());
            copth.setTh007(s.getWarehouse());
            copth.setTh056(s.getLocation());
            copth.setTh008(s.getOutQuantity());
            copth.setTh009(s.getUnit());
            copth.setTh006(copto.getTo009());
            copth.setTh014(copto.getTo004());
            copth.setTh015(copto.getTo005());
            copth.setTh016(copto.getTo006());
            if(StringUtils.isNotBlank(s.getBatchNo())){
                copth.setTh017(s.getBatchNo());
            }
            copth.setTh045(copto.getTo001());
            copth.setTh046(copto.getTo002());
            copth.setTh047(copto.getTo003());
            this.statAmount(copth, coptg, coptd);
            copthDao.save(copth);
            total = total.add(s.getOutQuantity());
            total025 = total025.add(copth.getTh036());
            total045 = total045.add(copth.getTh037());
            total046 = total046.add(copth.getTh038());
            total013 = total013.add(copth.getTh035());
            i++;
        }
        coptg.setTg013(total013);
        coptg.setTg033(total);
        coptg.setTg045(total045);
        coptg.setTg046(total046);
        coptg.setTg025(total025);
        coptgDao.save(coptg);
    }


    private void statAmount(Copth copth,Coptg coptg,Coptd coptd){
        //TH012     单价字段    根据订单单别(TH014)+订单号(TH015)+订单项次(TH016)    去获取对应订单单价
        copth.setTh012(coptd.getTd011());
        //TH013     金额字段     数量*单价
        copth.setTh013(copth.getTh008().multiply(coptd.getTd011())
                .setScale(2, RoundingMode.HALF_UP));
        //TH018     备注字段    根据订单单别(TH014)+订单号(TH015)+订单项次(TH016)    去获取对应订单表身备注
        copth.setTh018(coptd.getTd020());
        //TH019     客户品号字段    根据订单单别(TH014)+订单号(TH015)+订单项次(TH016)    去获取对应订单表身客户品号
        copth.setTh019(coptd.getTd014());
        //TH030=''   项目编号字段    根据订单单别(TH014)+订单号(TH015)+订单项次(TH016)    去获取对应订单表身项目编码
        copth.setTh030(coptd.getTd027());
        //TH048     税率字段    根据订单单别(TH014)+订单号(TH015)+订单项次(TH016)    去获取对应订单表身税率字段
        copth.setTh048(coptd.getTd037());
        //TH035     原币税前金额     如果表头字段TG017='1'   该字段的值为TH013-TH036        其他则等于TH013
        //TH036     原币税额         如果表头字段TG017='1'   该字段的值为TH013/(1+TH048)*TH048   如果表头字段TG017='2' 该字段的值为TH013*TH048   其他则等于0.00
        //TH038     本币税额        如果表头字段TG017='1'   该字段的值为TH013*COPTG.TG012/(1+TH048)*TH048   如果表头字段TG017='2' 该字段的值为TH013*TG012*TH048   其他则等于0.00
        //TH037     本币税前金额      如果表头字段TG017='1'   该字段的值为TH013*COPTG.TG012-TH038        其他则等于TH013*COPTG.TG012
        if("1".equals(coptg.getTg017())){
            copth.setTh036(copth.getTh013().divide(BigDecimal.ONE.add(copth.getTh048()), 2, RoundingMode.HALF_UP)
                    .multiply(copth.getTh048()).setScale(2, RoundingMode.HALF_UP));
            copth.setTh035(copth.getTh013().subtract(copth.getTh036()).setScale(2, RoundingMode.HALF_UP));
            copth.setTh038(copth.getTh013().multiply(coptg.getTg012()).divide(BigDecimal.ONE.add(copth.getTh048()),2, RoundingMode.HALF_UP).multiply(copth.getTh048())
                    .setScale(2, RoundingMode.HALF_UP));
            copth.setTh037(copth.getTh013().multiply(coptg.getTg012()).subtract(copth.getTh038())
                    .setScale(2, RoundingMode.HALF_UP));
        }else if("2".equals(coptg.getTg017())){
            copth.setTh036(copth.getTh013().multiply(copth.getTh048().setScale(2, RoundingMode.HALF_UP)));
            copth.setTh035(copth.getTh013());
            copth.setTh038(copth.getTh013().multiply(coptg.getTg012()).multiply(copth.getTh048()).setScale(2, RoundingMode.HALF_UP));
            copth.setTh037(copth.getTh013().multiply(coptg.getTg012())
                    .setScale(2, RoundingMode.HALF_UP));
        }else{
            copth.setTh036(BigDecimal.ZERO);
            copth.setTh035(copth.getTh013());
            copth.setTh038(BigDecimal.ZERO);
            copth.setTh037(copth.getTh013().multiply(coptg.getTg012())
                    .setScale(2, RoundingMode.HALF_UP));
        }
    }

    private String getNewTg002(String tg001) {
        String prefix = DateUtil.currentDateString();
        return coptgDao.findFirstByTg001AndTg002StartingWithOrderByTg002Desc(tg001, prefix)
                .map(i -> {
                    int currentOrdianl = Integer.parseInt(i.getTg002().replace(prefix, ""));
                    return prefix + String.format("%03d", currentOrdianl + 1);
                })
                .orElse(prefix + "001");
    }

}
