package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: PurtcId</p>
 * <p>Description: 采购单单头信息档主键</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/22
 */
public class PurtcId implements Serializable {
    public PurtcId() {
    }

    public PurtcId(String tc001, String tc002) {
        this.tc001 = String.format("%1$-4s", tc001);
        this.tc002 = String.format("%1$-11s", tc002);
    }

    private String tc001;
    private String tc002;

    public String getTc001() {
        return tc001;
    }

    public void setTc001(String tc001) {
        this.tc001 = tc001;
    }

    public String getTc002() {
        return tc002;
    }

    public void setTc002(String tc002) {
        this.tc002 = tc002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PurtcId purtcId = (PurtcId) o;
        return tc001.equals(purtcId.tc001) && tc002.equals(purtcId.tc002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tc001, tc002);
    }
}
