package com.topsunit.scanservice.ximai.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: PurtaId</p>
 * <p>Description: 请购单单头信息档ID</p>
 *
 * @author chicheng.li
 * @version V1.0
 */
@Data
public class PurtaId implements Serializable {

    public PurtaId() {
    }

    public PurtaId(String ta001, String ta002) {
        this.ta001 = ta001;
        this.ta002 = ta002;
    }

    /**
     * 请购单别
     */
    private String ta001;

    /**
     * 请购单号
     */
    private String ta002;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PurtaId id = (PurtaId) o;
        return ta001.equals(id.ta001) && ta002.equals(id.ta002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ta001, ta002);
    }
}
