package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * Author:   Jack
 * Date:     2021/10/28 15:42
 * Description: 工单单头Id
 */
public class MoctaId implements Serializable {
    public MoctaId() {
    }

    public MoctaId(String ta001, String ta002) {
        this.ta001 = String.format("%1$-4s", ta001);
        this.ta002 = String.format("%1$-11s", ta002);
    }

    private String ta001;
    private String ta002;

    public String getTa001() {
        return ta001;
    }

    public void setTa001(String ta001) {
        this.ta001 = ta001;
    }

    public String getTa002() {
        return ta002;
    }

    public void setTa002(String ta002) {
        this.ta002 = ta002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MoctaId moctaId = (MoctaId) o;
        return ta001.equals(moctaId.ta001) && ta002.equals(moctaId.ta002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ta001, ta002);
    }
}
