package com.topsunit.scanservice.ximai.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 采购到货参数
 */
@Data
public class StockArrivalParams {

    @ApiModelProperty("到货仓")
    String warehouse;

    @ApiModelProperty("发票号")
    String invoiceNo;

    @ApiModelProperty("确认明细")
    List<StockArrivalParams.StockArrivalDetail> details;
    @Data
    public static class StockArrivalDetail{
        @ApiModelProperty("供应商代码")
        String supplierNo;
        @ApiModelProperty("采购单单别")
        String purchaseType;
        @ApiModelProperty("采购单单号")
        String purchaseNo;
        @ApiModelProperty("采购单序号")
        String purchaseSerial;
        @ApiModelProperty("品号")
        String materialNo;
        @ApiModelProperty("到货数量")
        BigDecimal arrivalQuantity;
        @ApiModelProperty("生产日期")
        String productionDate;
        @ApiModelProperty("有效日期")
        String effectiveDate;
        @ApiModelProperty("批号")
        String batchNo;
    }
}
