package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.common.Constants;
import com.topsunit.scanservice.ximai.dao.WarehouseArriveDao;
import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.entity.Invmb;
import com.topsunit.scanservice.ximai.entity.Purtd;
import com.topsunit.scanservice.ximai.entity.WarehouseArrive;
import com.topsunit.scanservice.ximai.service.*;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Title: StockTakingController</p>
 * <p>Description: 库存相关操作</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/12/27
 */
@RestController
public class StockController {

    @Autowired
    private InvtaService invtaService;
    @Autowired
    private InvmcService invmcService;
    @Autowired
    private CopthService copthService;
    @Autowired
    private CoptoService coptoService;
    @Autowired
    private PurccService purccService;

    @ApiModelProperty("库存盘点确认")
    @PostMapping("/stockTaking/confirm")
    public void stockTakingConfirm(@RequestBody StockTakingParams params) {
        invtaService.createInvtaByStockTaking(params);
    }

    @ApiModelProperty("库存调拨确认")
    @PostMapping("/stockAllocate/confirm")
    public void stockAllocateConfirm(@RequestBody StockAllocateParams params) {
        invtaService.createInvtaByStockAllocate(params);
    }

    @ApiModelProperty("销售出库通知单查询")
    @PostMapping("/stockSaleOut/list")
    public StockSaleOutDto stockSaleOutList(@RequestBody StockSaleOutQueryParams params) {
        return coptoService.getStockSaleOutDto(params);
    }

    @ApiModelProperty("销售出库通知单库存查询")
    @PostMapping("/stockSaleOut/stockList")
    public List<InvmlDto> stockSaleOutStockList(@RequestBody StockSaleOutQueryParams params) {
        return invmcService.getInvmlWithCopto("251", params.getSaleOutNo());
    }

    @ApiModelProperty("销售出库确认")
    @PostMapping("/stockSaleOut/confirm")
    public void stockSaleOutConfirm(@RequestBody StockSaleOutParams params) {
        copthService.create(params);
    }
    @ApiModelProperty("到货确认")
    @PostMapping("/stockArrival/confirm")
    public void stockArrivalConfirm(@RequestBody StockArrivalParams params) {
        purccService.create(params);
    }

    @ApiModelProperty("到货校验")
    @PostMapping("/stockArrival/validate")
    public StockArrivalValidateDto stockArrivalValidate(@RequestBody StockArrivalValidateParams params) {
        Invmb invmb = purccService.validate(params);
        StockArrivalValidateDto rst = new StockArrivalValidateDto();
        rst.setInvmb(invmb);
        if("Y".equals(invmb.getMb022())){
            rst.setDefBatchNo(purccService.buildBatch(params.getMaterialNo()));
        }else {
            rst.setDefBatchNo(Constants.BATCH_DEF);
        }
        return rst;
    }

    @ApiModelProperty("到货仓查询")
    @PostMapping("/warehouseArrive/list")
    public List<WarehouseArriveDto> warehouseArriveList() {
        return invmcService.warehouseArriveList();
    }

}
