package com.topsunit.scanservice.ximai.service;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.CoptgDao;
import com.topsunit.scanservice.ximai.dao.CopthDao;
import com.topsunit.scanservice.ximai.dao.CoptoDao;
import com.topsunit.scanservice.ximai.dto.StockSaleOutDto;
import com.topsunit.scanservice.ximai.dto.StockSaleOutQueryParams;
import com.topsunit.scanservice.ximai.entity.Copth;
import com.topsunit.scanservice.ximai.entity.Copto;
import com.topsunit.scanservice.ximai.utils.MessageUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class CoptoService {

    @Autowired
    private CoptoDao coptoDao;
    @Autowired
    private CopthDao copthDao;

    /**
     * 查询出货通知单
     * @param params
     * @return
     */
    public StockSaleOutDto getStockSaleOutDto(StockSaleOutQueryParams params){
        StockSaleOutDto rst = new StockSaleOutDto();
        List<StockSaleOutDto.StockSaleOutDetail> data = new ArrayList<>();
        List<Copto> list = coptoDao.findByTo001AndTo002("251", params.getSaleOutNo());
        if(list.isEmpty()){
            throw new TopsunitException(MessageUtils.getMessage("未找到出货通知单：")+params.getSaleOutNo());
        }
        //查询已出库通知单数据，扣减相应数量
        Map<String, List<Copth>> copthMap = copthDao.findByTh045AndTh046("251", params.getSaleOutNo()).stream()
                .collect(Collectors.groupingBy(s->StrUtil.trim(s.getTh004())));
        Map<String, BigDecimal> copthQuantityMap = new HashMap<>();
        copthMap.forEach((k,v)->{
            copthQuantityMap.put(k, BigDecimal.ZERO);
            v.forEach(s->{
                copthQuantityMap.put(k, copthQuantityMap.get(k).add(s.getTh008()));
            });
        });
        list.forEach(s->{
            StockSaleOutDto.StockSaleOutDetail saleOutDetail = new StockSaleOutDto.StockSaleOutDetail();
            if(copthQuantityMap.containsKey(StrUtil.trim(s.getTo007()))){
                BigDecimal tempQuantity = NumberUtil.max(s.getTo024().subtract(copthQuantityMap.get(StrUtil.trim(s.getTo007()))), BigDecimal.ZERO);
                saleOutDetail.setDeliverQuantity(tempQuantity);
            }else{
                saleOutDetail.setDeliverQuantity(s.getTo024());
            }
            if(saleOutDetail.getDeliverQuantity().compareTo(BigDecimal.ZERO)<=0){
                return;
            }
            saleOutDetail.setPlanOutDate(s.getUdf01());
            saleOutDetail.setMaterialName(StrUtil.trim(s.getTo008()));
            saleOutDetail.setMaterialNo(StrUtil.trim(s.getTo007()));
            saleOutDetail.setUnit(StrUtil.trim(s.getTo010()));
            data.add(saleOutDetail);
        });
        if(data.isEmpty()){
            throw new TopsunitException(MessageUtils.getMessage("通知单{0}已全部出库", params.getSaleOutNo()));
        }
        rst.setData(data);
        rst.setApplyNo(params.getSaleOutNo());
        return rst;
    }

}
