package com.topsunit.scanservice.ximai.service;

import com.topsunit.scanservice.ximai.dao.CmsmcDao;
import com.topsunit.scanservice.ximai.dao.CmsniDao;
import com.topsunit.scanservice.ximai.dto.CmsmcCriteria;
import com.topsunit.scanservice.ximai.dto.CmsmcDto;
import com.topsunit.scanservice.ximai.dto.CmsniCriteria;
import com.topsunit.scanservice.ximai.dto.CmsniDto;
import com.topsunit.scanservice.ximai.dto.mapper.CmsmcMapper;
import com.topsunit.scanservice.ximai.dto.mapper.CmsniMapper;
import com.topsunit.scanservice.ximai.entity.Cmsmc;
import com.topsunit.scanservice.ximai.entity.Invml;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * <p>Title: CmsmcService</p>
 * <p>Description: 仓库库位档 service</p>
 *
 * @author chicheng.li
 * @version V1.0
 */
@Service
public class CmsmcService {
    @Autowired
    private CmsmcDao cmsmcDao;
    @Autowired
    private CmsmcMapper cmsmcMapper;


    public List<CmsmcDto> getCmsmcList(CmsmcCriteria criteria){
        Specification<Cmsmc> query = new Specification<Cmsmc>() {
            @Override
            public Predicate toPredicate(Root<Cmsmc> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                List<Predicate> predicates = new ArrayList<Predicate>();
                if (StringUtils.isNotBlank(criteria.getMc001())) {
                    Predicate predicate = criteriaBuilder.equal(root.get("mc001"), criteria.getMc001() );
                    predicates.add(predicate);
                }
                if (StringUtils.isNotBlank(criteria.getMc003())) {
                    Predicate predicate = criteriaBuilder.equal(root.get("mc003"), criteria.getMc003());
                    predicates.add(predicate);
                }
                return criteriaQuery.where(predicates.toArray(new Predicate[0])).getRestriction();
            }
        };
        List<Cmsmc> list = cmsmcDao.findAll(query);
        return cmsmcMapper.toCmsmcDtoList(list);
    }
}
