package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Id;
import java.io.Serializable;
import java.util.Objects;


@Data
public class MoctgId implements Serializable {
    public MoctgId() {
    }

    public MoctgId(String  tg001, String  tg002, String  tg003) {
        this. tg001 = tg001;
        this. tg002 = tg002;
        this. tg003 = tg003;
    }

    @ApiModelProperty("入库单别")
    private String tg001;
    @ApiModelProperty("入库单号")
    private String tg002;
    @ApiModelProperty("序号")
    private String tg003;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MoctgId id = (MoctgId) o;
        return  tg001.equals(id.tg001) &&  tg002.equals(id.tg002) &&  tg003.equals(id.tg003);
    }

    @Override
    public int hashCode() {
        return Objects.hash( tg001,  tg002,  tg003);
    }
}
