package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: InvmdId</p>
 * <p>Description: 品号换算单位档</p>
 *
 * @author xi.feng
 * @version V1.0
 */
public class InvmdId implements Serializable {

    public InvmdId() {
    }

    public InvmdId(String md001, String md002) {
        this.md001 = String.format("%1$-20s", md001);;
        this.md002 = String.format("%1$-4s", md002);;
    }

    /**
     * 品号
     */
    private String md001;

    /**
     * 换算单位
     */
    private String md002;

    public String getMd001() {
        return md001;
    }

    public void setMd001(String md001) {
        this.md001 = md001;
    }

    public String getMd002() {
        return md002;
    }

    public void setMd002(String md002) {
        this.md002 = md002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvmdId invmdId = (InvmdId) o;
        return md001.equals(invmdId.md001) && md002.equals(invmdId.md002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(md001, md002);
    }
}
