package com.topsunit.scanservice.ximai.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * Author:   Jack
 * Date:     2021/10/29 8:50
 * Description: 工单单头Dto
 */
@Data
public class MoctaDto {
    /*工单单别*/
    private String ta001;
    /*工单单号*/
    private String ta002;

    /*开单日期[FORMATE:YMD]*/
    private String ta003;
    /*BOM日期[FORMATE:YMD]*/
    private String ta004;
    @ApiModelProperty("BOM版本")
    private String ta005;
    @ApiModelProperty("产品品号")
    private String ta006;
    @ApiModelProperty("单位")
    private String ta007;
    /*预留字段 小单位*/
    private String ta008;
    /*预计开工[FORMATE:YMD]*/
    private String ta009;
    /*预计完工[FORMATE:YMD]*/
    private String ta010;
    /*状态码 1.未生产、2.已发料、3.生产中、Y.已完工、y.指定完工*/
    private String ta011;
    /*实际开工[FORMATE:YMD]*/
    private String ta012;
    /*审核码 Y、N、V*/
    private String ta013;
    /*实际完工[FORMATE:YMD]*/
    @ApiModelProperty("实际完工[FORMATE:YMD]")
    private String ta014;
    @ApiModelProperty("预计产量")
    private BigDecimal ta015;
    @ApiModelProperty("已领套数")
    private BigDecimal ta016;
    @ApiModelProperty("已生产量")
    private BigDecimal ta017;
    /*报废数量*/
    private BigDecimal ta018;
    @ApiModelProperty("工厂编号")
    private String ta019;
    /*入库仓库*/
    private String ta020;
    /*工作中心*/
    private String ta021;
    /*委外单价*/
    private BigDecimal ta022;
    /*加工单位*/
    private String ta023;
    /*源工单单别*/
    private String ta024;
    /*源工单编号*/
    private String ta025;
    /*订单单别*/
    private String ta026;
    /*订单单号*/
    private String ta027;
    /*订单序号*/
    private String ta028;
    /*备注*/
    private String ta029;
    /*性质 1.厂内工单、2.委外工单*/
    private String ta030;
    /*打印次数*/
    private Integer ta031;
    /*委外供应商*/
    private String ta032;
    /*计划批号*/
    private String ta033;
    /*产品品名*/
    private String ta034;
    /*产品规格*/
    private String ta035;
    /*预计开工 休假显示0.不休假、1.全天、2.半天*/
    private String ta036;
    /*预计完工 休假显示0.不休假、1.全天、2.半天*/
    private String ta037;
    /*实际开工 休假显示0.不休假、1.全天、2.半天*/
    private String ta038;
    /*实际完工 休假显示0.不休假、1.全天、2.半天*/
    private String ta039;
    /*审核日[FORMATE:YMD]*/
    private String ta040;
    /*审核者*/
    private String ta041;
    /*币种*/
    private String ta042;
    /*汇率*/
    private BigDecimal ta043;
    /*急料*/
    private String ta044;
    /*预计产包装量*/
    private BigDecimal ta045;
    /*已生产包装量*/
    private BigDecimal ta046;
    /*报废包装数量*/
    private BigDecimal ta047;
    /*包装单位*/
    private String ta048;
    /*签核状态码 0.待处理、S.传送中、1.签核中、2.退件、3.已核准、4.撤销审核中、5.作废中、6.取消作废中、N.不运行电子签核[DEF:"N"]*/
    private String ta049;
    /*其他备注一*/
    private String ta050;
    /*其他备注二*/
    private String ta051;
    /*其他备注三*/
    private String ta052;
    /*其他备注四*/
    private String ta053;
    /*传送次数[DEF:0]*/
    private Integer ta054;
    /*税种 1.应税内含、2.应税外加、3.零税率、4.免税、9.不计税*/
    private String ta055;
    /*加工数量*/
    private BigDecimal ta056;
    /*生产批号*/
    private String ta057;
    /*批号说明*/
    private String ta058;
    /*准产证 Y/N,[DEF:"N"]*/
    private String ta059;
    /*破坏数量*/
    private BigDecimal ta060;
    /*破坏包装数量*/
    private BigDecimal ta061;
    /*途程卡打印次数*/
    private Integer ta062;
    /*需求日期[FORMATE:YMD]*/
    private String ta063;
    /*部门编号*/
    private String ta064;
    /*预留字段*/
    private String ta065;
    /*预留字段*/
    private String ta066;
    /*预留字段*/
    private String ta067;
    /*预留字段*/
    private BigDecimal ta068;
    /*预留字段*/
    private BigDecimal ta069;
    /*预留字段*/
    private BigDecimal ta070;
    /*付款条件编号*/
    private String ta071;
    /*税率 税率(%)[DEF:9.9999]*/
    private BigDecimal ta072;
    /*配置方案*/
    private String ta073;
    /*配置序号*/
    private String ta074;
    /*已装配数量*/
    private BigDecimal tad01;
    /*类型 1.工程品号 2.正式品号[DEF:"2"]*/
    private String tac01;
    /*到货数量*/
    private BigDecimal tac02;
    /*到货包装数量*/
    private BigDecimal tac03;
    /*树状码*/
    private String ta075;
    /*根来源单别*/
    private String ta076;
    /*根来源单号*/
    private String ta077;
    /*根来源序号*/
    private String ta078;
    /*计划序号*/
    private String ta079;
    /*计划版本*/
    private String ta080;
    /*开工日占用天数*/
    private BigDecimal ta081;
    /*完工日占用天数*/
    private BigDecimal ta082;
    /*项目编号*/
    private String ta083;

    @ApiModelProperty("客户图号")
    private String udf02;
    @ApiModelProperty("客户项目号")
    private String udf03;
    @ApiModelProperty("客户编号")
    private String udf04;
    @ApiModelProperty("客户简称")
    private String udf05;
    @ApiModelProperty("同步标识")
    private String udf07;
    @ApiModelProperty("内部图号")
    private String udf08;

    @ApiModelProperty("创建时间")
    private String createDate;

    @ApiModelProperty("修改时间")
    private String modiDate;
    @ApiModelProperty("批次号")
    private String batchNo;


    /**
     * 工单材料明细
     */
    private List<MoctbDto> moctbDtos;
}
