package com.topsunit.scanservice.ximai.barcode.entity;

import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * <p>Title: ATCstDm</p>
 * <p>Description: 在线标签打印</p>
 *
 * @author system
 * @version V1.0
 * @date 2025/01/23
 */
@Data
@Entity
@Table(name = "ATCstDm")
public class ATCstDm {

    @Id
    @ApiModelProperty("MGPK")
    @Column(name = "MGPK")
    private String mgpk;
    
    @ApiModelProperty("业务员ID")
    @Column(name = "EmplID")
    private BigDecimal emplid;
    
    @ApiModelProperty("业务员编码")
    @Column(name = "EmplNo")
    private String emplno;
    
    @ApiModelProperty("业务员")
    @Column(name = "EmplName")
    private String emplname;
    
    @ApiModelProperty("部门ID")
    @Column(name = "DeptId")
    private BigDecimal deptid;
    
    @ApiModelProperty("部门编码")
    @Column(name = "DeptNo")
    private String deptno;
    
    @ApiModelProperty("部门")
    @Column(name = "DeptName")
    private String deptname;
    
    @ApiModelProperty("单据号")
    @Column(name = "MNo")
    private String mno;
    
    @ApiModelProperty("日期")
    @Column(name = "BDT")
    private String bdt;
    
    @ApiModelProperty("零件ID")
    @Column(name = "MItemID")
    private String mitemid;
    
    @ApiModelProperty("零件号")
    @Column(name = "mitemno")
    private String mitemno;
    
    @ApiModelProperty("客户品号")
    @Column(name = "mitemno_1")
    private String mitemno_1;
    
    @ApiModelProperty("itemmgpk")
    @Column(name = "itemmgpk")
    private String itemmgpk;
    
    @ApiModelProperty("databasename")
    @Column(name = "databasename")
    private String databasename;
    
    @ApiModelProperty("customcolumn01")
    @Column(name = "customcolumn01")
    private String customcolumn01;
    
    @ApiModelProperty("customcolumn02")
    @Column(name = "customcolumn02")
    private String customcolumn02;
    
    @ApiModelProperty("零件名称")
    @Column(name = "MItemName")
    private String mitemname;
    
    @ApiModelProperty("计划日期")
    @Column(name = "YMDT")
    private String ymdt;
    
    @ApiModelProperty("包装数量")
    @Column(name = "MQty")
    private String mqty;
    
    @ApiModelProperty("条码")
    @Column(name = "snno")
    private String snno;
    
    @ApiModelProperty("条码1")
    @Column(name = "snno1")
    private String snno1;
    
    @ApiModelProperty("箱码")
    @Column(name = "pSNNo")
    private String psnno;
    
    @ApiModelProperty("LMGPK")
    @Column(name = "LMGPK")
    private String lmgpk;
    
    @ApiModelProperty("早晚班")
    @Column(name = "Trick")
    private String trick;

    @ApiModelProperty("备注")
    @Column(name = "MNote")
    private String mnote;
    
    @ApiModelProperty("制单人")
    @Column(name = "Cuser")
    private String cuser;
    
    @ApiModelProperty("创建时间")
    @Column(name = "CDT")
    private String cdt;
    
    @ApiModelProperty("AID")
    @Column(name = "AID")
    private BigDecimal aid;

    @ApiModelProperty("MPK")
    @Column(name = "MPK")
    private BigDecimal mpk;
}
