package com.topsunit.scanservice.ximai.barcode.controller;

import com.topsunit.scanservice.ximai.barcode.dto.ATCstDmDto;
import com.topsunit.scanservice.ximai.barcode.service.ATCstDmService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

/**
 * <p>Title: ATCstDmController</p>
 * <p>Description: 在线标签打印控制器</p>
 *
 * @author system
 * @version V1.0
 * @date 2025/01/23
 */
@Api(tags = "在线标签打印管理")
@RestController
@RequestMapping("/api/barcode-system/atcstdm")
public class ATCstDmController {

    @Autowired
    private ATCstDmService atCstDmService;

    @ApiOperation("根据ID获取在线标签打印信息")
    @GetMapping("/{id}")
    public ATCstDmDto getById(@ApiParam("主键ID") @PathVariable String id) {
        return atCstDmService.getById(id);
    }

    @ApiOperation("获取在线标签打印列表")
    @GetMapping("/list")
    public Page<ATCstDmDto> getList(
            @ApiParam("查询条件") ATCstDmDto criteria,
            @ApiParam("页码") @RequestParam(defaultValue = "0") int page,
            @ApiParam("每页大小") @RequestParam(defaultValue = "10") int size) {
        return atCstDmService.getList(criteria, page, size);
    }

    @ApiOperation("保存在线标签打印信息")
    @PostMapping
    public ATCstDmDto save(@ApiParam("在线标签打印信息") @RequestBody ATCstDmDto dto) {
        return atCstDmService.save(dto);
    }

    @ApiOperation("更新在线标签打印信息")
    @PutMapping
    public ATCstDmDto update(@ApiParam("在线标签打印信息") @RequestBody ATCstDmDto dto) {
        return atCstDmService.update(dto);
    }

    @ApiOperation("删除在线标签打印信息")
    @DeleteMapping("/{id}")
    public String delete(@ApiParam("主键ID") @PathVariable String id) {
        return atCstDmService.delete(id);
    }
}
