package com.topsunit.scanservice.ximai.barcode.app;

import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import springfox.documentation.oas.annotations.EnableOpenApi;

/**
 * <p>Title: BarcodeSystemApplication</p>
 * <p>Description: 条码系统应用启动类</p>
 *
 * @author system
 * @version V1.0
 * @date 2025/01/23
 */
@SpringBootApplication
@ComponentScan(basePackages = {"com.topsunit"})
@EntityScan("com.topsunit.scanservice.ximai.barcode.entity")
@EnableJpaRepositories("com.topsunit.scanservice.ximai.barcode.dao")
@EnableFeignClients(basePackages = {"com.topsunit"})
@EnableKnife4j
@EnableOpenApi
public class BarcodeSystemApplication {
    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(BarcodeSystemApplication.class);
        application.run(args);
    }
}
