package com.topsunit.scanservice.ximai.service;

import cn.hutool.core.bean.BeanUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.*;
import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.dto.mapper.InvmbMapper;
import com.topsunit.scanservice.ximai.dto.mapper.InvmlMapper;
import com.topsunit.scanservice.ximai.entity.Invma;
import com.topsunit.scanservice.ximai.entity.Invmb;
import com.topsunit.scanservice.ximai.entity.Invmc;
import com.topsunit.scanservice.ximai.entity.Invml;
import com.topsunit.scanservice.ximai.utils.MessageUtils;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>Title: InvmcService</p>
 * <p>Description: 品号仓储信息档</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/12/27
 */
@Service
public class InvmcService {

    @Autowired
    private InvmcDao invmcDao;
    @Autowired
    private InvmlDao invmlDao;
    @Autowired
    private InvmbDao invmbDao;
    @Autowired
    private InvmlMapper invmlMapper;
    @Autowired
    private WarehouseArriveDao warehouseArriveDao;

    public List<InvmlDto> getInvmlList(InvmlCriteria criteria) {
        Specification<Invml> query = new Specification<Invml>() {
            @Override
            public Predicate toPredicate(Root<Invml> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                List<Predicate> predicates = new ArrayList<Predicate>();
                if (StringUtils.isNotBlank(criteria.getMl001())) {
                    Predicate predicate = criteriaBuilder.equal(root.get("ml001"), criteria.getMl001() );
                    predicates.add(predicate);
                }
                if (StringUtils.isNotBlank(criteria.getMl002())) {
                    Predicate predicate = criteriaBuilder.equal(root.get("ml002"), criteria.getMl002());
                    predicates.add(predicate);
                }
                return criteriaQuery.where(predicates.toArray(new Predicate[0])).getRestriction();
            }
        };
        List<Invml> list = invmlDao.findAll(query);
        return invmlMapper.toInvmlDto(list);
    }

    @ApiOperation("查询库存")
    public List<InvmlDto> getInvmlList2(InvmlCriteria criteria) {
        invmbDao.findById(criteria.getMl001()).orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到物料：")+criteria.getMl001()));

        List<IInvmlDto> data = invmlDao.findJoinInvmb(criteria.getMl001(), criteria.getMl002(), criteria.getGtStock());
        return data.stream().map(s->{
            InvmlDto temp = new InvmlDto();
            BeanUtils.copyProperties(s, temp);
            return temp;
        }).collect(Collectors.toList());
    }

    /**
     * 通过交货通知单查询库存
     * @param to001 单别
     * @param to002 单号
     * @return
     */
    public List<InvmlDto> getInvmlWithCopto(String to001,String to002){
        List<IInvmlDto> data = invmlDao.findWithCopto(to001, to002);
        return data.stream().map(s->{
            InvmlDto temp = new InvmlDto();
            BeanUtils.copyProperties(s, temp);
            return temp;
        }).collect(Collectors.toList());
    }

    public List<WarehouseArriveDto> warehouseArriveList() {
        return warehouseArriveDao.findAll().stream().map(s->{
            return BeanUtil.toBean(s, WarehouseArriveDto.class);
        }).collect(Collectors.toList());
    }
}
