package com.topsunit.scanservice.ximai.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.topsunit.scanservice.ximai.common.DateUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.*;
import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.dto.mapper.InvmlMapper;
import com.topsunit.scanservice.ximai.entity.Invmb;
import com.topsunit.scanservice.ximai.entity.Invml;
import com.topsunit.scanservice.ximai.entity.Invta;
import com.topsunit.scanservice.ximai.entity.Invtb;
import com.topsunit.scanservice.ximai.utils.MessageUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>Title: InvtaService</p>
 * <p>Description: 交易单据单</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/12/27
 */
@Service
public class InvtaService {

    @Autowired
    private InvtaDao invtaDao;
    @Autowired
    private InvtbDao invtbDao;
    @Autowired
    private InvmbDao invmbDao;

    private String inventory_shortage = "116";
    private String inventory_overage = "115";
    private String inventory_allocate = "128";

    /**
     * 创建盘点交易单据
     * @param params
     */
    @Transactional
    public void createInvtaByStockTaking(StockTakingParams params){
        List<StockTakingParams.StockTakingDetail> data = params.getData();
        //分组盘盈与盘亏
        List<StockTransactionParams> overageData = new ArrayList<>();
        List<StockTransactionParams> shortageData = new ArrayList<>();
        data.forEach(s->{
            StockTransactionParams temp = BeanUtil.toBeanIgnoreError(s, StockTransactionParams.class);
            temp.setQuantity(s.getPhysicalQuantity().subtract(s.getStockQuantity()).abs());
            if(s.getPhysicalQuantity().subtract(s.getStockQuantity()).compareTo(BigDecimal.ZERO)>0){
                overageData.add(temp);
            }else if(s.getPhysicalQuantity().subtract(s.getStockQuantity()).compareTo(BigDecimal.ZERO)<0){
                shortageData.add(temp);
            }
        });
        if(!overageData.isEmpty()){
            this.saveData(this.inventory_overage, overageData);
        }
        if(!shortageData.isEmpty()){
            this.saveData(this.inventory_shortage, shortageData);
        }
    }

    /**
     * 创建调拨交易单据
     * @param params
     */
    @Transactional
    public void createInvtaByStockAllocate(StockAllocateParams params){
        List<StockTransactionParams> tempData = new ArrayList<>();
        List<StockAllocateParams.StockAllocateDetail> data = params.getData();
        data.forEach(s->{
            StockTransactionParams temp = BeanUtil.toBeanIgnoreError(s, StockTransactionParams.class);
            temp.setQuantity(s.getAllocateQuantity());
            tempData.add(temp);
        });

        if(!data.isEmpty()){
            this.saveData(this.inventory_allocate, tempData);
        }
    }

    private void saveData(String type,List<StockTransactionParams> data){
        Invta invta = null;
        String ta002 = this.getNewTa002(type);
        if(type.equals(inventory_allocate)){
            invta = BeanUtil.toBeanIgnoreError(new InvtaCreateParamsAllo(), Invta.class);
            invta.setTa009("12");
        }else{
            invta = BeanUtil.toBeanIgnoreError(new InvtaCreateParams(), Invta.class);
            invta.setTa009("11");
        }
        invta.setTa001(type);
        invta.setTa002(ta002);
        String currDate = DateUtil.currentDateString();
        invta.setTa003(currDate);
        invta.setTa014(currDate);
        int i=1;
        BigDecimal total = BigDecimal.ZERO;
        for(StockTransactionParams detail : data){
            Object invtbDto = null;
            if(type.equals(inventory_allocate)) {
                invtbDto = new InvtbCreateParamsAllo();
            }else{
                invtbDto = new InvtbCreateParams();
            }
            //查询物料
            Invmb invmb = invmbDao.findById(detail.getMaterialNo())
                    .orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到对应物料：{0}", detail.getMaterialNo())));
            Invtb invtb = BeanUtil.toBeanIgnoreError(invtbDto, Invtb.class);
            invtb.setTb001(invta.getTa001());
            invtb.setTb002(invta.getTa002());
            invtb.setTb003(StringUtils.leftPad(i+"",4, "0"));
            invtb.setTb004(detail.getMaterialNo());
            invtb.setTb005(detail.getMaterialName());
            invtb.setTb006(invmb.getMb003());
            invtb.setTb008(invmb.getMb149());
            if(!type.equals(inventory_allocate)){
                invtb.setUdf01(invmb.getMb029());
            }
            //盘点数量
            invtb.setTb007(detail.getQuantity());
            invtb.setTb009(detail.getQuantity());
            //盘点仓库、库位
            invtb.setTb012(detail.getWarehouse());
            invtb.setTb019(currDate);
            invtb.setTb029(detail.getLocation());
            invtb.setTb014(detail.getBatchNo());
            //判断调拨库位是否与当前一致
            if(StringUtils.isNotEmpty(detail.getAllocateWarehouse()) &&
                    StringUtils.isNotEmpty(detail.getAllocateLocation())){
                if(StrUtil.trim(detail.getAllocateWarehouse()).equals(StrUtil.trim(detail.getWarehouse())) &&
                        StrUtil.trim(detail.getAllocateLocation()).equals(StrUtil.trim(detail.getLocation()))){
                    throw new TopsunitException(MessageUtils.getMessage("调拨库位与当前一致"));
                }
            }
            if(type.equals(inventory_allocate)) {
                invtb.setTb013(detail.getAllocateWarehouse());
                invtb.setTb030(detail.getAllocateLocation());
            }
            invtbDao.save(invtb);
            total = total.add(invtb.getTb007());
            i++;
        }
        invta.setTa011(total);
        invta.setTa012(BigDecimal.ZERO);
        invtaDao.save(invta);
    }

    private String getNewTa002(String ta001) {
        String prefix = DateUtil.currentDateString();
        return invtaDao.findFirstByTa001AndTa002StartingWithOrderByTa002Desc(ta001, prefix)
                .map(i -> {
                    int currentOrdianl = Integer.parseInt(i.getTa002().replace(prefix, ""));
                    return prefix + String.format("%03d", currentOrdianl + 1);
                })
                .orElse(prefix + "001");
    }

}
