package com.topsunit.scanservice.ximai.service;

import cn.hutool.core.bean.BeanUtil;
import com.topsunit.scanservice.ximai.common.AppConfig;
import com.topsunit.scanservice.ximai.common.StringUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.CmsmvDao;
import com.topsunit.scanservice.ximai.dao.ExAccountInfoDao;
import com.topsunit.scanservice.ximai.dto.ChangePasswordParams;
import com.topsunit.scanservice.ximai.dto.LoginParams;
import com.topsunit.scanservice.ximai.dto.LoginResult;
import com.topsunit.scanservice.ximai.dto.SetPasswordParams;
import com.topsunit.scanservice.ximai.dto.mapper.LoginMapper;
import com.topsunit.scanservice.ximai.entity.Cmsmv;
import com.topsunit.scanservice.ximai.entity.ExAccountInfo;
import com.topsunit.scanservice.ximai.security.*;
import com.topsunit.scanservice.ximai.utils.MessageUtils;
import com.topsunit.scanservice.ximai.webapi.MesLoginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Locale;

/**
 * <p>Title: CmsmvService</p>
 * <p>Description: 员工基本信息档</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/18
 */
@Service
public class CmsmvService {

    @Autowired
    MesLoginService mesLoginService;

    private final CmsmvDao cmsmvDao;
    private final LoginMapper loginMapper;
    private final TokenManger tokenManger;
    private final CurrentActor currentActor;
    private final Encryptor encryptor;
    private final AppConfig appConfig;
    @Autowired
    private ExAccountInfoDao exAccountInfoDao;
    @Autowired
    private TokenService tokenService;
    @Autowired
    ApplicationContext applicationContext;

    public CmsmvService(CmsmvDao cmsmvDao, LoginMapper loginMapper, TokenManger tokenManger, CurrentActor currentActor, Encryptor encryptor, AppConfig appConfig) {
        this.cmsmvDao = cmsmvDao;
        this.loginMapper = loginMapper;
        this.tokenManger = tokenManger;
        this.currentActor = currentActor;
        this.encryptor = encryptor;
        this.appConfig = appConfig;
    }

    public LoginResult login(LoginParams loginParams) {
        return cmsmvDao.findById(loginParams.getUsername())
                .filter(i -> {
                    if (StringUtil.isNullOrEmpty(i.getUdf01())) {
                        if (loginParams.getPassword().equals(appConfig.getDefaultPassword())) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                    return isMatchPassword(loginParams.getPassword(), i.getUdf01());
                })
                .map(loginMapper::toLoginResult)
                .map(i -> {
                    i.setToken(tokenManger.generate(i.getMv001(), Locale.getDefault().toString(),loginParams.getCompany()));
                    return i;
                })
                .orElseThrow(() -> new TopsunitException(MessageUtils.getMessage("用户名或密码错误。")));
    }

    public LoginResult loginByMes(LoginParams loginParams) {
        com.topsunit.scanservice.ximai.webapi.dto.LoginParams loginParams2 = BeanUtil.copyProperties(loginParams, com.topsunit.scanservice.ximai.webapi.dto.LoginParams.class);
        com.topsunit.scanservice.ximai.webapi.dto.LoginResult loginResult2 = mesLoginService.login(loginParams2);
        ExAccountInfo exAccountInfo = exAccountInfoDao.findById(Integer.valueOf(loginParams.getCompany())).orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到登录账套")));
        if(loginResult2.getCode()==500){
            throw new TopsunitException(loginResult2.getMsg());
        }
        LoginResult loginResult = tokenService.getUserByToken(loginResult2.getToken());
        if(StringUtil.isNullOrEmpty(exAccountInfo.getAccountCode())){
            throw new TopsunitException(MessageUtils.getMessage("请维护账套数据库编码"));
        }
        //生成扫码自生token
        String newToken = tokenManger.generate(loginParams.getUsername(), loginResult.getLocal(),exAccountInfo.getAccountCode());
        loginResult.setToken(newToken);
        return loginResult;
    }

    @Transactional
    public void setPassword(SetPasswordParams params) {
        Cmsmv cmsmv = cmsmvDao.findById(params.getMv001()).orElseThrow(() -> new TopsunitException(MessageUtils.getMessage("用户不存在")));
        if (!StringUtil.isNullOrEmpty(cmsmv.getUdf01())) {
            throw new TopsunitException(MessageUtils.getMessage("已经设置密码"));
        }
        cmsmv.setUdf01(encryptor.hash(params.getPassword()));
    }

    @Transactional
    public void changePassword(ChangePasswordParams params) {
        Cmsmv cmsmv = cmsmvDao.findById(currentActor.getActorStr()).orElseThrow(() -> new TopsunitException(MessageUtils.getMessage("用户不存在")));
        if (StringUtil.isNullOrEmpty(cmsmv.getUdf01())) {
            if (!params.getOldPassWord().equals(appConfig.getDefaultPassword())) {
                throw new TopsunitException(MessageUtils.getMessage("原密码输入有误"));
            }
        } else if (!isMatchPassword(params.getOldPassWord(), cmsmv.getUdf01())) {
            throw new TopsunitException(MessageUtils.getMessage("原密码输入有误"));
        }
        cmsmv.setUdf01(encryptor.hash(params.getNewPassword()));
    }

    private boolean isMatchPassword(String cleartext, String ciphertext){
        return encryptor.hash(cleartext).equals(ciphertext);
    }
}
