package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: SfctaId</p>
 * <p>Description: 工单工艺信息档Id</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/28
 */
public class SfctaId implements Serializable {
    public SfctaId() {
    }

    public SfctaId(String ta001, String ta002, String ta003, String ta006) {
        this.ta001 = String.format("%1$-4s", ta001);
        this.ta002 = String.format("%1$-11s", ta002);
        this.ta003 = String.format("%1$-4s", ta003);
        this.ta006 = String.format("%1$-10s",ta006);
    }

    private String ta001;
    private String ta002;
    private String ta003;
    private String ta006;

    public String getTa001() {
        return ta001;
    }

    public void setTa001(String ta001) {
        this.ta001 = ta001;
    }

    public String getTa002() {
        return ta002;
    }

    public void setTa002(String ta002) {
        this.ta002 = ta002;
    }

    public String getTa003() {
        return ta003;
    }

    public void setTa003(String ta003) {
        this.ta003 = ta003;
    }

    public String getTa006() {
        return ta006;
    }

    public void setTa006(String ta006) {
        this.ta006 = ta006;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SfctaId sfctaId = (SfctaId) o;
        return ta001.equals(sfctaId.ta001) && ta002.equals(sfctaId.ta002) && ta003.equals(sfctaId.ta003) && ta006.equals(sfctaId.ta006);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ta001, ta002, ta003, ta006);
    }
}
